/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.Plugin;
import org.sonar.api.SonarRuntime;
import org.sonar.api.config.Configuration;
import org.sonar.api.internal.PluginContextImpl;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.core.extension.ExtensionProviderSupport;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginRepository;

public abstract class ServerExtensionInstaller {
    private final SonarRuntime sonarRuntime;
    private final PluginRepository pluginRepository;
    private final Set<Class<? extends Annotation>> supportedAnnotationTypes;

    protected ServerExtensionInstaller(SonarRuntime sonarRuntime, PluginRepository pluginRepository, Class<? extends Annotation> ... supportedAnnotationTypes) {
        Objects.requireNonNull(supportedAnnotationTypes, "At least one supported annotation type must be specified");
        this.sonarRuntime = sonarRuntime;
        this.pluginRepository = pluginRepository;
        this.supportedAnnotationTypes = ImmutableSet.copyOf((Object[])supportedAnnotationTypes);
    }

    public void installExtensions(ComponentContainer container) {
        ArrayListMultimap installedExtensionsByPlugin = ArrayListMultimap.create();
        for (PluginInfo pluginInfo : this.pluginRepository.getPluginInfos()) {
            try {
                String pluginKey = pluginInfo.getKey();
                Plugin plugin = this.pluginRepository.getPluginInstance(pluginKey);
                container.addExtension(pluginInfo, (Object)plugin);
                Plugin.Context context = new PluginContextImpl.Builder().setSonarRuntime(this.sonarRuntime).setBootConfiguration((Configuration)container.getComponentByType(Configuration.class)).build();
                plugin.define(context);
                for (Object extension : context.getExtensions()) {
                    if (this.installExtension(container, pluginInfo, extension, true) != null) {
                        installedExtensionsByPlugin.put((Object)pluginInfo, extension);
                        continue;
                    }
                    container.declareExtension(pluginInfo, extension);
                }
            }
            catch (Throwable e) {
                throw new IllegalStateException(String.format("Fail to load plugin %s [%s]", pluginInfo.getName(), pluginInfo.getKey()), e);
            }
        }
        for (Map.Entry entry : installedExtensionsByPlugin.entries()) {
            PluginInfo pluginInfo = (PluginInfo)entry.getKey();
            try {
                Object extension = entry.getValue();
                if (!ExtensionProviderSupport.isExtensionProvider(extension)) continue;
                ExtensionProvider provider = (ExtensionProvider)container.getComponentByKey(extension);
                this.installProvider(container, pluginInfo, provider);
            }
            catch (Throwable e) {
                throw new IllegalStateException(String.format("Fail to load plugin %s [%s]", pluginInfo.getName(), pluginInfo.getKey()), e);
            }
        }
    }

    private void installProvider(ComponentContainer container, PluginInfo pluginInfo, ExtensionProvider provider) {
        Object obj = provider.provide();
        if (obj != null) {
            if (obj instanceof Iterable) {
                for (Object ext : (Iterable)obj) {
                    this.installExtension(container, pluginInfo, ext, false);
                }
            } else {
                this.installExtension(container, pluginInfo, obj, false);
            }
        }
    }

    Object installExtension(ComponentContainer container, PluginInfo pluginInfo, Object extension, boolean acceptProvider) {
        for (Class<? extends Annotation> supportedAnnotationType : this.supportedAnnotationTypes) {
            if (AnnotationUtils.getAnnotation((Object)extension, supportedAnnotationType) == null) continue;
            if (!acceptProvider && ExtensionProviderSupport.isExtensionProvider((Object)extension)) {
                throw new IllegalStateException("ExtensionProvider can not include providers itself: " + extension);
            }
            container.addExtension(pluginInfo, extension);
            return extension;
        }
        return null;
    }
}

