/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.web.requestid;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.sonar.server.platform.Platform;
import org.sonar.server.platform.web.requestid.RequestIdGenerator;
import org.sonar.server.platform.web.requestid.RequestIdMDCStorage;

public class RequestIdFilter
implements Filter {
    private final Platform platform;

    public RequestIdFilter() {
        this(Platform.getInstance());
    }

    @VisibleForTesting
    RequestIdFilter(Platform platform) {
        this.platform = platform;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RequestIdGenerator requestIdGenerator = (RequestIdGenerator)this.platform.getContainer().getComponentByType(RequestIdGenerator.class);
        if (requestIdGenerator == null) {
            chain.doFilter(request, response);
        } else {
            String requestId = requestIdGenerator.generate();
            try (RequestIdMDCStorage mdcStorage = new RequestIdMDCStorage(requestId);){
                request.setAttribute("ID", (Object)requestId);
                chain.doFilter(request, response);
            }
        }
    }

    public void destroy() {
    }
}

