/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.component.ComponentCleanerService;
import org.sonar.server.organization.BillingValidations;
import org.sonar.server.organization.BillingValidationsProxy;
import org.sonar.server.organization.DefaultOrganization;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.project.Project;
import org.sonar.server.project.ProjectLifeCycleListeners;
import org.sonar.server.qualityprofile.QProfileFactory;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.index.UserIndexer;
import org.sonar.server.ws.WsUtils;

public class DeleteAction
implements OrganizationsWsAction {
    private static final String ACTION = "delete";
    private final UserSession userSession;
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final ComponentCleanerService componentCleanerService;
    private final OrganizationFlags organizationFlags;
    private final UserIndexer userIndexer;
    private final QProfileFactory qProfileFactory;
    private final ProjectLifeCycleListeners projectLifeCycleListeners;
    private final BillingValidationsProxy billingValidations;

    public DeleteAction(UserSession userSession, DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider, ComponentCleanerService componentCleanerService, OrganizationFlags organizationFlags, UserIndexer userIndexer, QProfileFactory qProfileFactory, ProjectLifeCycleListeners projectLifeCycleListeners, BillingValidationsProxy billingValidations) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.componentCleanerService = componentCleanerService;
        this.organizationFlags = organizationFlags;
        this.userIndexer = userIndexer;
        this.qProfileFactory = qProfileFactory;
        this.projectLifeCycleListeners = projectLifeCycleListeners;
        this.billingValidations = billingValidations;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(true).setDescription("Delete an organization.<br/>Require 'Administer System' permission on the specified organization. Organization support must be enabled.").setInternal(true).setSince("6.2").setHandler((RequestHandler)this);
        action.createParam("organization").setRequired(true).setDescription("Organization key").setDeprecatedKey("key", "6.4").setExampleValue((Object)"foo-company");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.organizationFlags.checkEnabled(dbSession);
            String key = request.mandatoryParam("organization");
            DeleteAction.preventDeletionOfDefaultOrganization(key, this.defaultOrganizationProvider.get());
            OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, key), "Organization with key '%s' not found", key);
            if (organization.isGuarded()) {
                this.userSession.checkIsSystemAdministrator();
            } else {
                this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organization);
            }
            this.deleteProjects(dbSession, organization);
            this.deletePermissions(dbSession, organization);
            this.deleteGroups(dbSession, organization);
            this.deleteQualityProfiles(dbSession, organization);
            this.deleteQualityGates(dbSession, organization);
            this.deleteOrganization(dbSession, organization);
            this.billingValidations.onDelete(new BillingValidations.Organization(organization.getKey(), organization.getUuid()));
            response.noContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProjects(DbSession dbSession, OrganizationDto organization) {
        List roots = this.dbClient.componentDao().selectAllRootsByOrganization(dbSession, organization.getUuid());
        roots.forEach(project -> this.dbClient.webhookDao().selectByProject(dbSession, project).forEach(wh -> this.dbClient.webhookDeliveryDao().deleteByWebhook(dbSession, wh)));
        roots.forEach(project -> this.dbClient.webhookDao().deleteByProject(dbSession, project));
        try {
            this.componentCleanerService.delete(dbSession, roots);
        }
        finally {
            Set projects = (Set)roots.stream().filter(DeleteAction::isMainProject).map(Project::from).collect(MoreCollectors.toSet());
            this.projectLifeCycleListeners.onProjectsDeleted(projects);
        }
    }

    private static boolean isMainProject(ComponentDto p) {
        return "PRJ".equals(p.scope()) && "TRK".equals(p.qualifier()) && p.getMainBranchProjectUuid() == null;
    }

    private void deletePermissions(DbSession dbSession, OrganizationDto organization) {
        this.dbClient.permissionTemplateDao().deleteByOrganization(dbSession, organization.getUuid());
        dbSession.commit();
        this.dbClient.userPermissionDao().deleteByOrganization(dbSession, organization.getUuid());
        dbSession.commit();
        this.dbClient.groupPermissionDao().deleteByOrganization(dbSession, organization.getUuid());
        dbSession.commit();
    }

    private void deleteGroups(DbSession dbSession, OrganizationDto organization) {
        this.dbClient.groupDao().deleteByOrganization(dbSession, organization.getUuid());
        dbSession.commit();
    }

    private void deleteQualityProfiles(DbSession dbSession, OrganizationDto organization) {
        List profiles = this.dbClient.qualityProfileDao().selectOrderedByOrganizationUuid(dbSession, organization);
        this.qProfileFactory.delete(dbSession, profiles);
    }

    private void deleteQualityGates(DbSession dbSession, OrganizationDto organization) {
        Collection qualityGates = this.dbClient.qualityGateDao().selectAll(dbSession, organization);
        this.dbClient.qualityGateDao().deleteByUuids(dbSession, (Collection)qualityGates.stream().filter(q -> !q.isBuiltIn()).map(QualityGateDto::getUuid).collect(MoreCollectors.toList()));
        this.dbClient.qualityGateDao().deleteOrgQualityGatesByOrganization(dbSession, organization);
    }

    private void deleteOrganization(DbSession dbSession, OrganizationDto organization) {
        List uuids = this.dbClient.organizationMemberDao().selectUserUuidsByOrganizationUuid(dbSession, organization.getUuid());
        this.dbClient.organizationMemberDao().deleteByOrganizationUuid(dbSession, organization.getUuid());
        this.dbClient.organizationDao().deleteByUuid(dbSession, organization.getUuid());
        this.dbClient.userDao().cleanHomepage(dbSession, organization);
        this.dbClient.webhookDao().selectByOrganizationUuid(dbSession, organization.getUuid()).forEach(wh -> this.dbClient.webhookDeliveryDao().deleteByWebhook(dbSession, wh));
        this.dbClient.webhookDao().deleteByOrganization(dbSession, organization);
        List users = this.dbClient.userDao().selectByUuids(dbSession, (Collection)uuids);
        this.userIndexer.commitAndIndex(dbSession, users);
    }

    private static void preventDeletionOfDefaultOrganization(String key, DefaultOrganization defaultOrganization) {
        Preconditions.checkArgument((!defaultOrganization.getKey().equals(key) ? 1 : 0) != 0, (Object)"Default Organization can't be deleted");
    }
}

