/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.metric.MetricDtoFunctions;
import org.sonar.server.measure.ws.MetricDtoWithBestValue;
import org.sonarqube.ws.Common;

class SearchHistoryResult {
    private final int page;
    private final int pageSize;
    private List<SnapshotDto> analyses;
    private List<MetricDto> metrics;
    private List<MeasureDto> measures;
    private Common.Paging paging;
    private ComponentDto component;

    SearchHistoryResult(int page, int pageSize) {
        this.page = page;
        this.pageSize = pageSize;
    }

    public ComponentDto getComponent() {
        return Objects.requireNonNull(this.component);
    }

    SearchHistoryResult setComponent(ComponentDto component) {
        this.component = component;
        return this;
    }

    List<SnapshotDto> getAnalyses() {
        return Objects.requireNonNull(this.analyses);
    }

    SearchHistoryResult setAnalyses(List<SnapshotDto> analyses) {
        this.paging = Common.Paging.newBuilder().setPageIndex(this.page).setPageSize(this.pageSize).setTotal(analyses.size()).build();
        this.analyses = (List)analyses.stream().skip(Paging.offset((int)this.page, (int)this.pageSize)).limit(this.pageSize).collect(MoreCollectors.toList());
        return this;
    }

    List<MetricDto> getMetrics() {
        return Objects.requireNonNull(this.metrics);
    }

    SearchHistoryResult setMetrics(List<MetricDto> metrics) {
        this.metrics = metrics;
        return this;
    }

    List<MeasureDto> getMeasures() {
        return Objects.requireNonNull(this.measures);
    }

    SearchHistoryResult setMeasures(List<MeasureDto> measures) {
        Set analysisUuids = (Set)this.analyses.stream().map(SnapshotDto::getUuid).collect(MoreCollectors.toHashSet());
        ImmutableList.Builder measuresBuilder = ImmutableList.builder();
        List filteredMeasures = (List)measures.stream().filter(measure -> analysisUuids.contains(measure.getAnalysisUuid())).collect(MoreCollectors.toArrayList());
        measuresBuilder.addAll((Iterable)filteredMeasures);
        measuresBuilder.addAll(this.computeBestValues(filteredMeasures));
        this.measures = measuresBuilder.build();
        return this;
    }

    private List<MeasureDto> computeBestValues(List<MeasureDto> measures) {
        if (!MetricDtoWithBestValue.isEligibleForBestValue().test(this.component)) {
            return Collections.emptyList();
        }
        Objects.requireNonNull(this.metrics);
        Objects.requireNonNull(this.analyses);
        HashBasedTable measuresByMetricIdAndAnalysisUuid = HashBasedTable.create((int)this.metrics.size(), (int)this.analyses.size());
        measures.forEach(arg_0 -> SearchHistoryResult.lambda$computeBestValues$1((Table)measuresByMetricIdAndAnalysisUuid, arg_0));
        ArrayList<MeasureDto> bestValues = new ArrayList<MeasureDto>();
        this.metrics.stream().filter(MetricDtoFunctions.isOptimizedForBestValue()).forEach(arg_0 -> this.lambda$computeBestValues$4((Table)measuresByMetricIdAndAnalysisUuid, bestValues, arg_0));
        return bestValues;
    }

    private static MeasureDto toBestValue(MetricDto metric, SnapshotDto analysis) {
        MeasureDto measure = new MeasureDto().setMetricId(metric.getId().intValue()).setAnalysisUuid(analysis.getUuid());
        if (metric.getKey().startsWith("new_")) {
            measure.setVariation(metric.getBestValue());
        } else {
            measure.setValue(metric.getBestValue());
        }
        return measure;
    }

    Common.Paging getPaging() {
        return Objects.requireNonNull(this.paging);
    }

    private /* synthetic */ void lambda$computeBestValues$4(Table measuresByMetricIdAndAnalysisUuid, List bestValues, MetricDto metric) {
        this.analyses.stream().filter(analysis -> !measuresByMetricIdAndAnalysisUuid.contains((Object)metric.getId(), (Object)analysis.getUuid())).map(analysis -> SearchHistoryResult.toBestValue(metric, analysis)).forEach(bestValues::add);
    }

    private static /* synthetic */ void lambda$computeBestValues$1(Table measuresByMetricIdAndAnalysisUuid, MeasureDto measure) {
        MeasureDto cfr_ignored_0 = (MeasureDto)measuresByMetricIdAndAnalysisUuid.put((Object)measure.getMetricId(), (Object)measure.getAnalysisUuid(), (Object)measure);
    }
}

