/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.custom.ws;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.custom.CustomMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.measure.custom.ws.CustomMeasureJsonWriter;
import org.sonar.server.measure.custom.ws.CustomMeasureValidator;
import org.sonar.server.measure.custom.ws.CustomMeasureValueDescription;
import org.sonar.server.measure.custom.ws.CustomMeasuresWsAction;
import org.sonar.server.user.UserSession;

public class UpdateAction
implements CustomMeasuresWsAction {
    public static final String ACTION = "update";
    public static final String PARAM_ID = "id";
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_DESCRIPTION = "description";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final System2 system;
    private final CustomMeasureValidator validator;
    private final CustomMeasureJsonWriter customMeasureJsonWriter;

    public UpdateAction(DbClient dbClient, UserSession userSession, System2 system, CustomMeasureValidator validator, CustomMeasureJsonWriter customMeasureJsonWriter) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.system = system;
        this.validator = validator;
        this.customMeasureJsonWriter = customMeasureJsonWriter;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(true).setDescription("Update a custom measure. Value and/or description must be provided<br />Requires 'Administer System' permission or 'Administer' permission on the project.").setHandler((RequestHandler)this).setSince("5.2");
        action.createParam(PARAM_ID).setRequired(true).setDescription(PARAM_ID).setExampleValue((Object)"42");
        action.createParam(PARAM_VALUE).setExampleValue((Object)"true").setDescription(CustomMeasureValueDescription.measureValueDescription());
        action.createParam(PARAM_DESCRIPTION).setExampleValue((Object)"Team size growing.");
    }

    public void handle(Request request, Response response) throws Exception {
        int id = request.mandatoryParamAsInt(PARAM_ID);
        String value = request.param(PARAM_VALUE);
        String description = request.param(PARAM_DESCRIPTION);
        UpdateAction.checkParameters(value, description);
        try (DbSession dbSession = this.dbClient.openSession(true);){
            CustomMeasureDto customMeasure = this.dbClient.customMeasureDao().selectById(dbSession, (long)id);
            Preconditions.checkArgument((customMeasure != null ? 1 : 0) != 0, (String)"Custom measure with id '%s' does not exist", (Object[])new Object[]{id});
            int customMetricId = customMeasure.getMetricId();
            MetricDto metric = this.dbClient.metricDao().selectById(dbSession, (long)customMetricId);
            Preconditions.checkState((metric != null ? 1 : 0) != 0, (String)"Metric with id '%s' does not exist", (Object[])new Object[]{customMetricId});
            ComponentDto component = this.dbClient.componentDao().selectOrFailByUuid(dbSession, customMeasure.getComponentUuid());
            CustomMeasureValidator.checkPermissions(this.userSession, component);
            String userUuid = Objects.requireNonNull(this.userSession.getUuid(), "User uuid should not be null");
            UserDto user = this.dbClient.userDao().selectByUuid(dbSession, userUuid);
            Preconditions.checkState((user != null ? 1 : 0) != 0, (String)"User with uuid '%s' does not exist", (Object[])new Object[]{userUuid});
            this.setValue(customMeasure, value, metric);
            UpdateAction.setDescription(customMeasure, description);
            customMeasure.setUserUuid(user.getUuid());
            customMeasure.setUpdatedAt(this.system.now());
            this.dbClient.customMeasureDao().update(dbSession, customMeasure);
            dbSession.commit();
            JsonWriter json = response.newJsonWriter();
            this.customMeasureJsonWriter.write(json, customMeasure, metric, component, user, true, CustomMeasureJsonWriter.OPTIONAL_FIELDS);
            json.close();
        }
    }

    private void setValue(CustomMeasureDto customMeasure, @Nullable String value, MetricDto metric) {
        if (value != null) {
            this.validator.setMeasureValue(customMeasure, value, metric);
        }
    }

    private static void setDescription(CustomMeasureDto customMeasure, @Nullable String description) {
        if (description != null) {
            customMeasure.setDescription(description);
        }
    }

    private static void checkParameters(@Nullable String value, @Nullable String description) {
        if (value == null && description == null) {
            throw new IllegalArgumentException("Value or description must be provided.");
        }
    }
}

