/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.custom.ws;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.custom.CustomMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.measure.custom.ws.CustomMeasureJsonWriter;
import org.sonar.server.measure.custom.ws.CustomMeasureValidator;
import org.sonar.server.measure.custom.ws.CustomMeasureValueDescription;
import org.sonar.server.measure.custom.ws.CustomMeasuresWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class CreateAction
implements CustomMeasuresWsAction {
    public static final String ACTION = "create";
    public static final String PARAM_PROJECT_ID = "projectId";
    public static final String PARAM_PROJECT_KEY = "projectKey";
    public static final String PARAM_METRIC_ID = "metricId";
    public static final String PARAM_METRIC_KEY = "metricKey";
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_DESCRIPTION = "description";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final System2 system;
    private final CustomMeasureValidator validator;
    private final CustomMeasureJsonWriter customMeasureJsonWriter;
    private final ComponentFinder componentFinder;

    public CreateAction(DbClient dbClient, UserSession userSession, System2 system, CustomMeasureValidator validator, CustomMeasureJsonWriter customMeasureJsonWriter, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.system = system;
        this.validator = validator;
        this.customMeasureJsonWriter = customMeasureJsonWriter;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setDescription("Create a custom measure.<br /> The project id or the project key must be provided (only project and module custom measures can be created). The metric id or the metric key must be provided.<br/>Requires 'Administer' permission on the project.").setSince("5.2").setPost(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_PROJECT_ID).setDescription("Project id").setExampleValue((Object)"ce4c03d6-430f-40a9-b777-ad877c00aa4d");
        action.createParam(PARAM_PROJECT_KEY).setDescription("Project key").setExampleValue((Object)"my_project");
        action.createParam(PARAM_METRIC_ID).setDescription("Metric id").setExampleValue((Object)"16");
        action.createParam(PARAM_METRIC_KEY).setDescription("Metric key").setExampleValue((Object)"ncloc");
        action.createParam(PARAM_VALUE).setRequired(true).setDescription(CustomMeasureValueDescription.measureValueDescription()).setExampleValue((Object)"47");
        action.createParam(PARAM_DESCRIPTION).setDescription("Description").setExampleValue((Object)"Team size growing.");
    }

    public void handle(Request request, Response response) throws Exception {
        String valueAsString = request.mandatoryParam(PARAM_VALUE);
        String description = request.param(PARAM_DESCRIPTION);
        long now = this.system.now();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.componentFinder.getByUuidOrKey(dbSession, request.param(PARAM_PROJECT_ID), request.param(PARAM_PROJECT_KEY), ComponentFinder.ParamNames.PROJECT_ID_AND_KEY);
            MetricDto metric = this.searchMetric(dbSession, request);
            CustomMeasureValidator.checkPermissions(this.userSession, component);
            CreateAction.checkIsProjectOrModule(component);
            this.checkMeasureDoesNotExistAlready(dbSession, component, metric);
            String userUuid = Objects.requireNonNull(this.userSession.getUuid(), "User uuid should not be null");
            UserDto user = this.dbClient.userDao().selectByUuid(dbSession, userUuid);
            Preconditions.checkState((user != null ? 1 : 0) != 0, (String)"User with uuid '%s' does not exist", (Object[])new Object[]{userUuid});
            CustomMeasureDto measure = new CustomMeasureDto().setComponentUuid(component.uuid()).setMetricId(metric.getId().intValue()).setDescription(description).setUserUuid(user.getUuid()).setCreatedAt(now).setUpdatedAt(now);
            this.validator.setMeasureValue(measure, valueAsString, metric);
            this.dbClient.customMeasureDao().insert(dbSession, measure);
            dbSession.commit();
            JsonWriter json = response.newJsonWriter();
            this.customMeasureJsonWriter.write(json, measure, metric, component, user, true, CustomMeasureJsonWriter.OPTIONAL_FIELDS);
            json.close();
        }
    }

    private static void checkIsProjectOrModule(ComponentDto component) {
        WsUtils.checkRequest("PRJ".equals(component.scope()), "Component '%s' must be a project or a module.", component.getDbKey());
    }

    private void checkMeasureDoesNotExistAlready(DbSession dbSession, ComponentDto component, MetricDto metric) {
        int nbMeasuresOnSameMetricAndMeasure = this.dbClient.customMeasureDao().countByComponentIdAndMetricId(dbSession, component.uuid(), metric.getId().intValue());
        WsUtils.checkRequest(nbMeasuresOnSameMetricAndMeasure == 0, "A measure already exists for project '%s' and metric '%s'", component.getDbKey(), metric.getKey());
    }

    private MetricDto searchMetric(DbSession dbSession, Request request) {
        Integer metricId = request.paramAsInt(PARAM_METRIC_ID);
        String metricKey = request.param(PARAM_METRIC_KEY);
        Preconditions.checkArgument((boolean)(metricId != null ^ metricKey != null), (Object)"Either the metric id or the metric key must be provided");
        if (metricId == null) {
            MetricDto metric = this.dbClient.metricDao().selectByKey(dbSession, metricKey);
            Preconditions.checkArgument((metric != null ? 1 : 0) != 0, (String)"Metric with key '%s' does not exist", (Object[])new Object[]{metricKey});
            return metric;
        }
        MetricDto metric = this.dbClient.metricDao().selectById(dbSession, (long)metricId.intValue());
        Preconditions.checkArgument((metric != null ? 1 : 0) != 0, (String)"Metric with id '%s' does not exist", (Object[])new Object[]{metricId});
        return metric;
    }
}

