/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.io.Resources;
import java.util.Collection;
import java.util.Date;
import org.sonar.api.issue.DefaultTransitions;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueDto;
import org.sonar.server.issue.IssueFinder;
import org.sonar.server.issue.IssueUpdater;
import org.sonar.server.issue.TransitionService;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.issue.ws.OperationResponseWriter;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class DoTransitionAction
implements IssuesWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final IssueFinder issueFinder;
    private final IssueUpdater issueUpdater;
    private final TransitionService transitionService;
    private final OperationResponseWriter responseWriter;
    private final System2 system2;

    public DoTransitionAction(DbClient dbClient, UserSession userSession, IssueFinder issueFinder, IssueUpdater issueUpdater, TransitionService transitionService, OperationResponseWriter responseWriter, System2 system2) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.issueFinder = issueFinder;
        this.issueUpdater = issueUpdater;
        this.transitionService = transitionService;
        this.responseWriter = responseWriter;
        this.system2 = system2;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("do_transition").setDescription("Do workflow transition on an issue. Requires authentication and Browse permission on project.<br/>The transitions 'wontfix' and 'falsepositive' require the permission 'Administer Issues'.").setSince("3.6").setChangelog(new Change[]{new Change("6.5", "the database ids of the components are removed from the response"), new Change("6.5", "the response field components.uuid is deprecated. Use components.key instead.")}).setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"do_transition-example.json")).setPost(true);
        action.createParam("issue").setDescription("Issue key").setRequired(true).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("transition").setDescription("Transition").setRequired(true).setPossibleValues((Collection)DefaultTransitions.ALL);
    }

    public void handle(Request request, Response response) {
        this.userSession.checkLoggedIn();
        String issue = request.mandatoryParam("issue");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            IssueDto issueDto = this.issueFinder.getByKey(dbSession, issue);
            WsUtils.checkRequest(!issueDto.isExternal(), "Transition is not allowed on issues imported from external rule engines", new Object[0]);
            SearchResponseData preloadedSearchResponseData = this.doTransition(dbSession, issueDto, request.mandatoryParam("transition"));
            this.responseWriter.write(issue, preloadedSearchResponseData, request, response);
        }
    }

    private SearchResponseData doTransition(DbSession session, IssueDto issueDto, String transitionKey) {
        DefaultIssue defaultIssue = issueDto.toDefaultIssue();
        IssueChangeContext context = IssueChangeContext.createUser((Date)new Date(this.system2.now()), (String)this.userSession.getUuid());
        this.transitionService.checkTransitionPermission(transitionKey, defaultIssue);
        if (this.transitionService.doTransition(defaultIssue, context, transitionKey)) {
            return this.issueUpdater.saveIssueAndPreloadSearchResponseData(session, defaultIssue, context, null, true);
        }
        return new SearchResponseData(issueDto);
    }
}

