/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.collect.Multimap;
import java.util.Collection;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.server.notification.NotificationDispatcher;
import org.sonar.server.notification.NotificationDispatcherMetadata;
import org.sonar.server.notification.NotificationManager;

public class MyNewIssuesNotificationDispatcher
extends NotificationDispatcher {
    public static final String KEY = "SQ-MyNewIssues";
    private final NotificationManager manager;

    public MyNewIssuesNotificationDispatcher(NotificationManager manager) {
        super("my-new-issues");
        this.manager = manager;
    }

    public static NotificationDispatcherMetadata newMetadata() {
        return NotificationDispatcherMetadata.create(KEY).setProperty("globalNotification", String.valueOf(true)).setProperty("perProjectNotification", String.valueOf(true));
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void dispatch(Notification notification, NotificationDispatcher.Context context) {
        String projectKey = notification.getFieldValue("projectKey");
        String assignee = notification.getFieldValue("assignee");
        Multimap<String, NotificationChannel> subscribedRecipients = this.manager.findSubscribedRecipientsForDispatcher(this, projectKey, NotificationManager.SubscriberPermissionsOnProject.ALL_MUST_HAVE_ROLE_USER);
        Collection channels = subscribedRecipients.get((Object)assignee);
        for (NotificationChannel channel : channels) {
            context.addUser(assignee, channel);
        }
    }
}

