/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.notifications.Notification;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.FieldDiffs;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.user.UserDto;

public class IssueChangeNotification
extends Notification {
    public static final String TYPE = "issue-changes";

    public IssueChangeNotification() {
        super(TYPE);
    }

    public IssueChangeNotification setIssue(DefaultIssue issue) {
        this.setFieldValue("key", issue.key());
        this.setFieldValue("message", issue.message());
        FieldDiffs currentChange = issue.currentChange();
        if (currentChange != null) {
            for (Map.Entry entry : currentChange.diffs().entrySet()) {
                String type = (String)entry.getKey();
                FieldDiffs.Diff diff = (FieldDiffs.Diff)entry.getValue();
                this.setFieldValue("old." + type, IssueChangeNotification.neverEmptySerializableToString(diff.oldValue()));
                this.setFieldValue("new." + type, IssueChangeNotification.neverEmptySerializableToString(diff.newValue()));
            }
        }
        return this;
    }

    public IssueChangeNotification setProject(ComponentDto project) {
        return this.setProject(project.getKey(), project.name(), project.getBranch(), project.getPullRequest());
    }

    public IssueChangeNotification setProject(String projectKey, String projectName, @Nullable String branch, @Nullable String pullRequest) {
        this.setFieldValue("projectName", projectName);
        this.setFieldValue("projectKey", projectKey);
        if (branch != null) {
            this.setFieldValue("branch", branch);
        }
        if (pullRequest != null) {
            this.setFieldValue("pullRequest", pullRequest);
        }
        return this;
    }

    public IssueChangeNotification setComponent(ComponentDto component) {
        return this.setComponent(component.getKey(), component.longName());
    }

    public IssueChangeNotification setComponent(String componentKey, String componentName) {
        this.setFieldValue("componentName", componentName);
        this.setFieldValue("componentKey", componentKey);
        return this;
    }

    public IssueChangeNotification setChangeAuthor(@Nullable UserDto author) {
        if (author == null) {
            return this;
        }
        this.setFieldValue("changeAuthor", author.getLogin());
        return this;
    }

    public IssueChangeNotification setRuleName(@Nullable String s) {
        if (s != null) {
            this.setFieldValue("ruleName", s);
        }
        return this;
    }

    public IssueChangeNotification setComment(@Nullable String s) {
        if (s != null) {
            this.setFieldValue("comment", s);
        }
        return this;
    }

    @CheckForNull
    private static String neverEmptySerializableToString(@Nullable Serializable s) {
        return s != null ? Strings.emptyToNull((String)s.toString()) : null;
    }

    public IssueChangeNotification setAssignee(@Nullable UserDto assignee) {
        if (assignee != null) {
            this.setFieldValue("assignee", assignee.getLogin());
        }
        return this;
    }
}

