/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import java.util.Collection;
import org.sonar.api.issue.Issue;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.System2;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.server.issue.IssueStorage;
import org.sonar.server.issue.index.IssueIndexer;

@ServerSide
public class ServerIssueStorage
extends IssueStorage {
    private final IssueIndexer indexer;

    public ServerIssueStorage(System2 system2, RuleFinder ruleFinder, DbClient dbClient, IssueIndexer indexer) {
        super(system2, dbClient, ruleFinder);
        this.indexer = indexer;
    }

    @Override
    protected IssueDto doInsert(DbSession session, long now, DefaultIssue issue) {
        ComponentDto component = this.component(session, issue);
        ComponentDto project = this.project(session, issue);
        int ruleId = this.rule((Issue)issue).getId();
        IssueDto dto = IssueDto.toDtoForServerInsert((DefaultIssue)issue, (ComponentDto)component, (ComponentDto)project, (int)ruleId, (long)now);
        this.getDbClient().issueDao().insert(session, dto);
        return dto;
    }

    @Override
    protected IssueDto doUpdate(DbSession session, long now, DefaultIssue issue) {
        IssueDto dto = IssueDto.toDtoForUpdate((DefaultIssue)issue, (long)now);
        this.getDbClient().issueDao().update(session, dto);
        return dto;
    }

    @Override
    protected void doAfterSave(DbSession dbSession, Collection<IssueDto> issues) {
        this.indexer.commitAndIndexIssues(dbSession, issues);
    }

    protected ComponentDto component(DbSession session, DefaultIssue issue) {
        return this.getDbClient().componentDao().selectOrFailByUuid(session, issue.componentUuid());
    }

    protected ComponentDto project(DbSession session, DefaultIssue issue) {
        return this.getDbClient().componentDao().selectOrFailByUuid(session, issue.projectUuid());
    }
}

