/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sonar.api.issue.Issue;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.System2;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.DefaultIssueComment;
import org.sonar.core.issue.FieldDiffs;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueChangeMapper;
import org.sonar.db.issue.IssueDto;

public abstract class IssueStorage {
    private final System2 system2;
    private final RuleFinder ruleFinder;
    private final DbClient dbClient;

    protected IssueStorage(System2 system2, DbClient dbClient, RuleFinder ruleFinder) {
        this.system2 = system2;
        this.dbClient = dbClient;
        this.ruleFinder = ruleFinder;
    }

    protected DbClient getDbClient() {
        return this.dbClient;
    }

    public void save(DefaultIssue issue) {
        this.save(Lists.newArrayList((Object[])new DefaultIssue[]{issue}));
    }

    public IssueDto save(DbSession session, DefaultIssue issue) {
        return this.doSave(session, Lists.newArrayList((Object[])new DefaultIssue[]{issue})).iterator().next();
    }

    public Collection<IssueDto> save(Iterable<DefaultIssue> issues) {
        try (DbSession session = this.dbClient.openSession(true);){
            Collection<IssueDto> collection = this.doSave(session, issues);
            return collection;
        }
    }

    private Collection<IssueDto> doSave(DbSession dbSession, Iterable<DefaultIssue> issues) {
        long now = this.system2.now();
        Map<Boolean, List<DefaultIssue>> issuesNewOrUpdated = StreamSupport.stream(issues.spliterator(), true).collect(Collectors.groupingBy(DefaultIssue::isNew));
        List issuesToInsert = (List)MoreObjects.firstNonNull(issuesNewOrUpdated.get(true), Collections.emptyList());
        List issuesToUpdate = (List)MoreObjects.firstNonNull(issuesNewOrUpdated.get(false), Collections.emptyList());
        Collection<IssueDto> inserted = this.insert(dbSession, issuesToInsert, now);
        Collection<IssueDto> updated = this.update(issuesToUpdate, now);
        this.doAfterSave(dbSession, (Collection)Stream.concat(inserted.stream(), updated.stream()).collect(MoreCollectors.toSet((int)(issuesToInsert.size() + issuesToUpdate.size()))));
        return (Collection)Stream.concat(inserted.stream(), updated.stream()).collect(MoreCollectors.toSet((int)(issuesToInsert.size() + issuesToUpdate.size())));
    }

    protected void doAfterSave(DbSession dbSession, Collection<IssueDto> issues) {
    }

    private Collection<IssueDto> insert(DbSession session, Iterable<DefaultIssue> issuesToInsert, long now) {
        ArrayList inserted = Lists.newArrayList();
        int count = 0;
        IssueChangeMapper issueChangeMapper = (IssueChangeMapper)session.getMapper(IssueChangeMapper.class);
        for (DefaultIssue issue : issuesToInsert) {
            IssueDto issueDto = this.doInsert(session, now, issue);
            inserted.add(issueDto);
            IssueStorage.insertChanges(issueChangeMapper, issue);
            if (count > 250) {
                session.commit();
                count = 0;
            }
            ++count;
        }
        session.commit();
        return inserted;
    }

    protected abstract IssueDto doInsert(DbSession var1, long var2, DefaultIssue var4);

    private Collection<IssueDto> update(List<DefaultIssue> issuesToUpdate, long now) {
        ArrayList<IssueDto> updated = new ArrayList<IssueDto>();
        if (!issuesToUpdate.isEmpty()) {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                IssueChangeMapper issueChangeMapper = (IssueChangeMapper)dbSession.getMapper(IssueChangeMapper.class);
                for (DefaultIssue issue : issuesToUpdate) {
                    IssueDto issueDto = this.doUpdate(dbSession, now, issue);
                    updated.add(issueDto);
                    IssueStorage.insertChanges(issueChangeMapper, issue);
                }
                dbSession.commit();
            }
        }
        return updated;
    }

    protected abstract IssueDto doUpdate(DbSession var1, long var2, DefaultIssue var4);

    public static void insertChanges(IssueChangeMapper mapper, DefaultIssue issue) {
        for (Object comment : issue.defaultIssueComments()) {
            if (!comment.isNew()) continue;
            IssueChangeDto changeDto = IssueChangeDto.of((DefaultIssueComment)comment);
            mapper.insert(changeDto);
        }
        FieldDiffs diffs = issue.currentChange();
        if (issue.isCopied()) {
            for (FieldDiffs d : issue.changes()) {
                IssueChangeDto changeDto = IssueChangeDto.of((String)issue.key(), (FieldDiffs)d);
                mapper.insert(changeDto);
            }
        } else if (!issue.isNew() && diffs != null) {
            IssueChangeDto changeDto = IssueChangeDto.of((String)issue.key(), (FieldDiffs)diffs);
            mapper.insert(changeDto);
        }
    }

    protected Rule rule(Issue issue) {
        Rule rule = this.ruleFinder.findByKey(issue.ruleKey());
        if (rule == null) {
            throw new IllegalStateException("Rule not found: " + issue.ruleKey());
        }
        return rule;
    }
}

