/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.api.issue.condition.Condition;
import org.sonar.api.issue.condition.IsUnResolved;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.rule.RuleTagFormat;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.issue.Action;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.user.UserSession;

@ServerSide
public abstract class AbstractChangeTagsAction
extends Action {
    public static final String TAGS_PARAMETER = "tags";
    private static final Splitter TAGS_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final IssueFieldsSetter issueUpdater;

    protected AbstractChangeTagsAction(String key, IssueFieldsSetter issueUpdater) {
        super(key);
        this.issueUpdater = issueUpdater;
        super.setConditions(new Condition[]{new IsUnResolved()});
    }

    @Override
    public boolean verify(Map<String, Object> properties, Collection<DefaultIssue> issues, UserSession userSession) {
        this.parseTags(properties);
        return true;
    }

    @Override
    public boolean execute(Map<String, Object> properties, Action.Context context) {
        Collection<String> tags = this.getTagsToSet(context, this.parseTags(properties));
        return this.issueUpdater.setTags(context.issue(), tags, context.issueChangeContext());
    }

    protected abstract Collection<String> getTagsToSet(Action.Context var1, Collection<String> var2);

    @Override
    public boolean shouldRefreshMeasures() {
        return false;
    }

    private Set<String> parseTags(Map<String, Object> properties) {
        HashSet<String> result = new HashSet<String>();
        String tagsString = (String)properties.get(TAGS_PARAMETER);
        if (!Strings.isNullOrEmpty((String)tagsString)) {
            for (String tag : TAGS_SPLITTER.split((CharSequence)tagsString)) {
                RuleTagFormat.validate((String)tag);
                result.add(tag);
            }
        }
        return result;
    }
}

