/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.metadata;

import java.util.Optional;
import org.sonar.db.DbClient;
import org.sonar.server.es.metadata.EsDbCompatibility;
import org.sonar.server.es.metadata.MetadataIndex;

public class EsDbCompatibilityImpl
implements EsDbCompatibility {
    private final DbClient dbClient;
    private final MetadataIndex metadataIndex;

    public EsDbCompatibilityImpl(DbClient dbClient, MetadataIndex metadataIndex) {
        this.dbClient = dbClient;
        this.metadataIndex = metadataIndex;
    }

    @Override
    public boolean hasSameDbVendor() {
        Optional<String> registeredDbVendor = this.metadataIndex.getDbVendor();
        return registeredDbVendor.isPresent() && registeredDbVendor.get().equals(this.getDbVendor());
    }

    @Override
    public void markAsCompatible() {
        this.metadataIndex.setDbMetadata(this.getDbVendor());
    }

    private String getDbVendor() {
        return this.dbClient.getDatabase().getDialect().getId();
    }
}

