/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.sonar.server.es.BaseDoc;
import org.sonar.server.es.EsUtils;
import org.sonar.server.es.Facets;

public class SearchResult<DOC extends BaseDoc> {
    private final List<DOC> docs;
    private final Facets facets;
    private final long total;

    public SearchResult(SearchResponse response, Function<Map<String, Object>, DOC> converter, TimeZone timeZone) {
        this.facets = new Facets(response, timeZone);
        this.total = response.getHits().getTotalHits();
        this.docs = EsUtils.convertToDocs(response.getHits(), converter);
    }

    public List<DOC> getDocs() {
        return this.docs;
    }

    public long getTotal() {
        return this.total;
    }

    public Facets getFacets() {
        return this.facets;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

