/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.settings.Settings;
import org.sonar.api.config.Configuration;
import org.sonar.process.ProcessProperties;
import org.sonar.server.es.DefaultIndexSettings;
import org.sonar.server.es.DefaultIndexSettingsElement;
import org.sonar.server.permission.index.AuthorizationTypeSupport;

public class NewIndex {
    private final String indexName;
    private final Settings.Builder settings = DefaultIndexSettings.defaults();
    private final Map<String, NewIndexType> types = new LinkedHashMap<String, NewIndexType>();

    NewIndex(String indexName, SettingsConfiguration settingsConfiguration) {
        Preconditions.checkArgument((boolean)StringUtils.isAllLowerCase((String)indexName), (Object)("Index name must be lower-case: " + indexName));
        this.indexName = indexName;
        this.applySettingsConfiguration(settingsConfiguration);
    }

    private void applySettingsConfiguration(SettingsConfiguration settingsConfiguration) {
        this.settings.put("index.mapper.dynamic", String.valueOf(false));
        this.settings.put("index.refresh_interval", NewIndex.refreshInterval(settingsConfiguration));
        Configuration config = settingsConfiguration.getConfiguration();
        boolean clusterMode = config.getBoolean(ProcessProperties.Property.CLUSTER_ENABLED.getKey()).orElse(false);
        int shards = config.getInt(String.format("sonar.search.%s.shards", this.indexName)).orElse(settingsConfiguration.getDefaultNbOfShards());
        int replicas = clusterMode ? config.getInt(ProcessProperties.Property.SEARCH_REPLICAS.getKey()).orElse(1) : 0;
        this.settings.put("index.number_of_shards", shards);
        this.settings.put("index.number_of_replicas", replicas);
    }

    private static String refreshInterval(SettingsConfiguration settingsConfiguration) {
        int refreshInterval = settingsConfiguration.getRefreshInterval();
        if (refreshInterval == -1) {
            return "-1";
        }
        return refreshInterval + "s";
    }

    public String getName() {
        return this.indexName;
    }

    public Settings.Builder getSettings() {
        return this.settings;
    }

    public NewIndexType createType(String typeName) {
        NewIndexType type = new NewIndexType(this, typeName);
        this.types.put(typeName, type);
        return type;
    }

    public Map<String, NewIndexType> getTypes() {
        return this.types;
    }

    public static class NestedFieldBuilder {
        private final NewIndexType indexType;
        private final String fieldName;
        private final Map<String, Object> properties = new TreeMap<String, Object>();

        private NestedFieldBuilder(NewIndexType indexType, String fieldName) {
            this.indexType = indexType;
            this.fieldName = fieldName;
        }

        private NestedFieldBuilder setProperty(String fieldName, Object value) {
            this.properties.put(fieldName, value);
            return this;
        }

        public NestedFieldBuilder addKeywordField(String fieldName) {
            return this.setProperty(fieldName, ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"keyword", (Comparable)((Object)"index"), (Object)"true"));
        }

        public NestedFieldBuilder addDoubleField(String fieldName) {
            return this.setProperty(fieldName, ImmutableMap.of((Object)"type", (Object)"double"));
        }

        public NestedFieldBuilder addIntegerField(String fieldName) {
            return this.setProperty(fieldName, ImmutableMap.of((Object)"type", (Object)"integer"));
        }

        public NewIndexType build() {
            Preconditions.checkArgument((!this.properties.isEmpty() ? 1 : 0) != 0, (String)"At least one sub-field must be declared in nested property '%s'", (Object[])new Object[]{this.fieldName});
            return this.indexType.setProperty(this.fieldName, ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"nested", (Comparable)((Object)"properties"), this.properties));
        }
    }

    public static class TextFieldBuilder
    extends StringFieldBuilder<TextFieldBuilder> {
        private boolean fieldData = false;

        private TextFieldBuilder(NewIndexType indexType, String fieldName) {
            super(indexType, fieldName);
        }

        @Override
        protected String getFieldType() {
            return "text";
        }

        public StringFieldBuilder withFieldData() {
            this.fieldData = true;
            return this;
        }

        @Override
        protected boolean getFieldData() {
            return this.fieldData;
        }
    }

    public static class KeywordFieldBuilder
    extends StringFieldBuilder<KeywordFieldBuilder> {
        private KeywordFieldBuilder(NewIndexType indexType, String fieldName) {
            super(indexType, fieldName);
        }

        @Override
        protected boolean getFieldData() {
            return false;
        }

        @Override
        protected String getFieldType() {
            return "keyword";
        }

        public KeywordFieldBuilder disableSortingAndAggregating() {
            this.disabledDocValues = true;
            return this;
        }
    }

    public static abstract class StringFieldBuilder<T extends StringFieldBuilder<T>> {
        private final NewIndexType indexType;
        private final String fieldName;
        private boolean disableSearch = false;
        private boolean disableNorms = false;
        private boolean termVectorWithPositionOffsets = false;
        private SortedMap<String, Object> subFields = Maps.newTreeMap();
        private boolean store = false;
        protected boolean disabledDocValues = false;

        private StringFieldBuilder(NewIndexType indexType, String fieldName) {
            this.indexType = indexType;
            this.fieldName = fieldName;
        }

        private T addSubField(String fieldName, SortedMap<String, String> fieldDefinition) {
            this.subFields.put(fieldName, fieldDefinition);
            return this.castThis();
        }

        public T addSubFields(DefaultIndexSettingsElement ... analyzers) {
            Arrays.stream(analyzers).forEach(analyzer -> this.addSubField(analyzer.getSubFieldSuffix(), analyzer.fieldMapping()));
            return this.castThis();
        }

        public T disableNorms() {
            this.disableNorms = true;
            return this.castThis();
        }

        public T termVectorWithPositionOffsets() {
            this.termVectorWithPositionOffsets = true;
            return this.castThis();
        }

        public T disableSearch() {
            this.disableSearch = true;
            return this.castThis();
        }

        public T store() {
            this.store = true;
            return this.castThis();
        }

        private T castThis() {
            return (T)this;
        }

        public NewIndexType build() {
            if (this.subFields.isEmpty()) {
                return this.buildWithoutSubfields();
            }
            return this.buildWithSubfields();
        }

        private NewIndexType buildWithoutSubfields() {
            TreeMap<String, String> hash = new TreeMap<String, String>();
            hash.put("type", this.getFieldType());
            hash.put("index", this.disableSearch ? "false" : "true");
            hash.put("norms", String.valueOf(!this.disableNorms));
            hash.put("store", String.valueOf(this.store));
            if ("keyword".equals(this.getFieldType())) {
                hash.put("doc_values", String.valueOf(!this.disabledDocValues));
            }
            if (this.getFieldData()) {
                hash.put("fielddata", "true");
            }
            return this.indexType.setProperty(this.fieldName, hash);
        }

        private NewIndexType buildWithSubfields() {
            TreeMap<String, Object> hash = new TreeMap<String, Object>();
            hash.put("type", this.getFieldType());
            hash.put("index", this.disableSearch ? "false" : "true");
            hash.put("norms", "false");
            hash.put("store", String.valueOf(this.store));
            if ("keyword".equals(this.getFieldType())) {
                hash.put("doc_values", String.valueOf(!this.disabledDocValues));
            }
            if (this.getFieldData()) {
                hash.put("fielddata", "true");
            }
            if (this.termVectorWithPositionOffsets) {
                hash.put("term_vector", "with_positions_offsets");
            }
            hash.put("fields", this.configureSubFields());
            return this.indexType.setProperty(this.fieldName, hash);
        }

        private Map<String, Object> configureSubFields() {
            TreeMap<String, Object> multiFields = new TreeMap<String, Object>(this.subFields);
            multiFields.entrySet().forEach(entry -> {
                Object subFieldMapping = entry.getValue();
                if (subFieldMapping instanceof Map) {
                    entry.setValue(this.configureSubField((Map)subFieldMapping));
                }
            });
            return multiFields;
        }

        private Map<String, String> configureSubField(Map<String, String> subFieldMapping) {
            TreeMap<String, String> subHash = new TreeMap<String, String>(subFieldMapping);
            subHash.put("index", "true");
            subHash.put("norms", "false");
            subHash.put("store", String.valueOf(this.store));
            if (this.termVectorWithPositionOffsets) {
                subHash.put("term_vector", "with_positions_offsets");
            }
            return subHash;
        }

        protected abstract boolean getFieldData();

        protected abstract String getFieldType();
    }

    public static class NewIndexType {
        private final NewIndex index;
        private final String name;
        private final Map<String, Object> attributes = new TreeMap<String, Object>();
        private final Map<String, Object> properties = new TreeMap<String, Object>();

        private NewIndexType(NewIndex index, String typeName) {
            this.index = index;
            this.name = typeName;
            this.attributes.put("dynamic", false);
            this.attributes.put("_all", ImmutableSortedMap.of((Comparable)((Object)"enabled"), (Object)false));
            this.attributes.put("_source", ImmutableSortedMap.of((Comparable)((Object)"enabled"), (Object)true));
            this.attributes.put("properties", this.properties);
        }

        public NewIndexType requireProjectAuthorization() {
            AuthorizationTypeSupport.enableProjectAuthorization(this);
            return this;
        }

        public NewIndex getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public NewIndexType setAttribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public NewIndexType setProperty(String key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public NewIndexType setEnableSource(boolean enableSource) {
            this.attributes.put("_source", ImmutableSortedMap.of((Comparable)((Object)"enabled"), (Object)enableSource));
            return this;
        }

        public KeywordFieldBuilder keywordFieldBuilder(String fieldName) {
            return new KeywordFieldBuilder(this, fieldName);
        }

        public TextFieldBuilder textFieldBuilder(String fieldName) {
            return new TextFieldBuilder(this, fieldName);
        }

        public NestedFieldBuilder nestedFieldBuilder(String fieldName) {
            return new NestedFieldBuilder(this, fieldName);
        }

        public NewIndexType createBooleanField(String fieldName) {
            return this.setProperty(fieldName, ImmutableMap.of((Object)"type", (Object)"boolean"));
        }

        public NewIndexType createByteField(String fieldName) {
            return this.setProperty(fieldName, ImmutableMap.of((Object)"type", (Object)"byte"));
        }

        public NewIndexType createDateTimeField(String fieldName) {
            TreeMap<String, String> hash = new TreeMap<String, String>();
            hash.put("type", "date");
            hash.put("format", "date_time||epoch_second");
            return this.setProperty(fieldName, hash);
        }

        public NewIndexType createDoubleField(String fieldName) {
            return this.setProperty(fieldName, ImmutableMap.of((Object)"type", (Object)"double"));
        }

        public NewIndexType createIntegerField(String fieldName) {
            return this.setProperty(fieldName, ImmutableMap.of((Object)"type", (Object)"integer"));
        }

        public NewIndexType createLongField(String fieldName) {
            return this.setProperty(fieldName, ImmutableMap.of((Object)"type", (Object)"long"));
        }

        public NewIndexType createShortField(String fieldName) {
            return this.setProperty(fieldName, ImmutableMap.of((Object)"type", (Object)"short"));
        }

        public NewIndexType createUuidPathField(String fieldName) {
            return this.setProperty(fieldName, ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"text", (Comparable)((Object)"index"), (Object)"true", (Comparable)((Object)"analyzer"), (Object)DefaultIndexSettingsElement.UUID_MODULE_ANALYZER.getName()));
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @CheckForNull
        public Object getProperty(String key) {
            return this.properties.get(key);
        }
    }

    public static class SettingsConfiguration {
        public static final int MANUAL_REFRESH_INTERVAL = -1;
        private final Configuration configuration;
        private final int defaultNbOfShards;
        private final int refreshInterval;

        private SettingsConfiguration(Builder builder) {
            this.configuration = builder.configuration;
            this.defaultNbOfShards = builder.defaultNbOfShards;
            this.refreshInterval = builder.refreshInterval;
        }

        public static Builder newBuilder(Configuration configuration) {
            return new Builder(configuration);
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public int getDefaultNbOfShards() {
            return this.defaultNbOfShards;
        }

        public int getRefreshInterval() {
            return this.refreshInterval;
        }

        public static class Builder {
            private final Configuration configuration;
            private int defaultNbOfShards = 1;
            private int refreshInterval = 30;

            public Builder(Configuration configuration) {
                this.configuration = Objects.requireNonNull(configuration, "configuration can't be null");
            }

            public Builder setDefaultNbOfShards(int defaultNbOfShards) {
                Preconditions.checkArgument((defaultNbOfShards >= 1 ? 1 : 0) != 0, (Object)"defaultNbOfShards must be >= 1");
                this.defaultNbOfShards = defaultNbOfShards;
                return this;
            }

            public Builder setRefreshInterval(int refreshInterval) {
                Preconditions.checkArgument((refreshInterval == -1 || refreshInterval > 0 ? 1 : 0) != 0, (Object)"refreshInterval must be either -1 or strictly positive");
                this.refreshInterval = refreshInterval;
                return this;
            }

            public SettingsConfiguration build() {
                return new SettingsConfiguration(this);
            }
        }
    }
}

