/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.server.es.EsUtils;

public abstract class BaseDoc {
    protected final Map<String, Object> fields;

    protected BaseDoc() {
        this.fields = new HashMap<String, Object>();
    }

    protected BaseDoc(Map<String, Object> fields) {
        this.fields = fields;
    }

    public abstract String getId();

    @CheckForNull
    public abstract String getRouting();

    @CheckForNull
    public abstract String getParent();

    @CheckForNull
    public <K> K getNullableField(String key) {
        if (!this.fields.containsKey(key)) {
            throw new IllegalStateException(String.format("Field %s not specified in query options", key));
        }
        return (K)this.fields.get(key);
    }

    @CheckForNull
    public Date getNullableFieldAsDate(String key) {
        Object val = this.getNullableField(key);
        if (val != null) {
            if (val instanceof Date) {
                return (Date)val;
            }
            if (val instanceof Number) {
                return BaseDoc.epochSecondsToDate((Number)val);
            }
            return EsUtils.parseDateTime((String)val);
        }
        return null;
    }

    public <K> K getField(String key) {
        K value = this.getNullableField(key);
        if (value == null) {
            throw new IllegalStateException("Value of index field is null: " + key);
        }
        return value;
    }

    public Date getFieldAsDate(String key) {
        Object value = this.getField(key);
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            return BaseDoc.epochSecondsToDate((Number)value);
        }
        return EsUtils.parseDateTime((String)value);
    }

    public void setField(String key, @Nullable Object value) {
        this.fields.put(key, value);
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public static long epochMillisToEpochSeconds(long epochMillis) {
        return epochMillis / 1000L;
    }

    private static Date epochSecondsToDate(Number value) {
        return new Date(value.longValue() * 1000L);
    }

    public static long dateToEpochSeconds(Date date) {
        return BaseDoc.epochMillisToEpochSeconds(date.getTime());
    }
}

