/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.formula.Counter;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.server.computation.task.projectanalysis.formula.Formula;
import org.sonar.server.computation.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.formula.counter.IntSumCounter;
import org.sonar.server.computation.task.projectanalysis.formula.counter.LongSumCounter;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class UnitTestMeasuresStep
implements ComputationStep {
    private static final String[] METRICS = new String[]{"tests", "test_errors", "test_failures", "skipped_tests", "test_success_density", "test_execution_time"};
    private static final ImmutableList<Formula> FORMULAS = ImmutableList.of((Object)new UnitTestsFormula());
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;

    public UnitTestMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
    }

    @Override
    public void execute() {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor((Iterable<Formula>)FORMULAS)).visit(this.treeRootHolder.getRoot());
    }

    @Override
    public String getDescription() {
        return "Compute test measures";
    }

    private static class UnitTestsCounter
    implements Counter<UnitTestsCounter> {
        private final IntSumCounter testsCounter = new IntSumCounter("tests");
        private final IntSumCounter testsErrorsCounter = new IntSumCounter("test_errors");
        private final IntSumCounter testsFailuresCounter = new IntSumCounter("test_failures");
        private final IntSumCounter skippedTestsCounter = new IntSumCounter("skipped_tests");
        private final LongSumCounter testExecutionTimeCounter = new LongSumCounter("test_execution_time");
        private Component leaf;

        private UnitTestsCounter() {
        }

        @Override
        public void aggregate(UnitTestsCounter counter) {
            this.testsCounter.aggregate(counter.testsCounter);
            this.testsErrorsCounter.aggregate(counter.testsErrorsCounter);
            this.testsFailuresCounter.aggregate(counter.testsFailuresCounter);
            this.skippedTestsCounter.aggregate(counter.skippedTestsCounter);
            this.testExecutionTimeCounter.aggregate(counter.testExecutionTimeCounter);
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            this.leaf = context.getLeaf();
            this.testsCounter.initialize(context);
            this.testsErrorsCounter.initialize(context);
            this.testsFailuresCounter.initialize(context);
            this.skippedTestsCounter.initialize(context);
            this.testExecutionTimeCounter.initialize(context);
        }

        Component getLeaf() {
            return this.leaf;
        }
    }

    private static class UnitTestsFormula
    implements Formula<UnitTestsCounter> {
        private UnitTestsFormula() {
        }

        @Override
        public UnitTestsCounter createNewCounter() {
            return new UnitTestsCounter();
        }

        @Override
        public Optional<Measure> createMeasure(UnitTestsCounter counter, CreateMeasureContext context) {
            String metricKey = context.getMetric().getKey();
            Component leaf = counter.getLeaf();
            switch (metricKey) {
                case "tests": {
                    return UnitTestsFormula.createIntMeasure(context.getComponent(), leaf, counter.testsCounter.getValue());
                }
                case "test_errors": {
                    return UnitTestsFormula.createIntMeasure(context.getComponent(), leaf, counter.testsErrorsCounter.getValue());
                }
                case "test_failures": {
                    return UnitTestsFormula.createIntMeasure(context.getComponent(), leaf, counter.testsFailuresCounter.getValue());
                }
                case "skipped_tests": {
                    return UnitTestsFormula.createIntMeasure(context.getComponent(), leaf, counter.skippedTestsCounter.getValue());
                }
                case "test_execution_time": {
                    return UnitTestsFormula.createLongMeasure(context.getComponent(), leaf, counter.testExecutionTimeCounter.getValue());
                }
                case "test_success_density": {
                    return UnitTestsFormula.createDensityMeasure(counter, context.getMetric().getDecimalScale());
                }
            }
            throw new IllegalStateException(String.format("Metric '%s' is not supported", metricKey));
        }

        private static Optional<Measure> createIntMeasure(Component currentComponent, Component leafComponent, Optional<Integer> metricValue) {
            if (metricValue.isPresent() && leafComponent.getType().isDeeperThan(currentComponent.getType())) {
                return Optional.of((Object)Measure.newMeasureBuilder().create((Integer)metricValue.get()));
            }
            return Optional.absent();
        }

        private static Optional<Measure> createLongMeasure(Component currentComponent, Component leafComponent, Optional<Long> metricValue) {
            if (metricValue.isPresent() && leafComponent.getType().isDeeperThan(currentComponent.getType())) {
                return Optional.of((Object)Measure.newMeasureBuilder().create((Long)metricValue.get()));
            }
            return Optional.absent();
        }

        private static Optional<Measure> createDensityMeasure(UnitTestsCounter counter, int decimalScale) {
            if (UnitTestsFormula.isPositive(counter.testsCounter.getValue(), true) && UnitTestsFormula.isPositive(counter.testsErrorsCounter.getValue(), false) && UnitTestsFormula.isPositive(counter.testsFailuresCounter.getValue(), false)) {
                int tests = (Integer)counter.testsCounter.getValue().get();
                int errors = (Integer)counter.testsErrorsCounter.getValue().get();
                int failures = (Integer)counter.testsFailuresCounter.getValue().get();
                double density = (double)(errors + failures) * 100.0 / (double)tests;
                return Optional.of((Object)Measure.newMeasureBuilder().create(100.0 - density, decimalScale));
            }
            return Optional.absent();
        }

        private static boolean isPositive(Optional<Integer> value, boolean isStrictComparison) {
            return value.isPresent() && (isStrictComparison ? (Integer)value.get() > 0 : (Integer)value.get() >= 0);
        }

        @Override
        public String[] getOutputMetricKeys() {
            return METRICS;
        }
    }
}

