/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import org.sonar.api.utils.Duration;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchType;
import org.sonar.db.user.UserDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.analysis.Branch;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.issue.IssueCache;
import org.sonar.server.computation.task.projectanalysis.issue.RuleRepository;
import org.sonar.server.computation.task.step.ComputationStep;
import org.sonar.server.issue.notification.IssueChangeNotification;
import org.sonar.server.issue.notification.MyNewIssuesNotification;
import org.sonar.server.issue.notification.NewIssuesNotification;
import org.sonar.server.issue.notification.NewIssuesNotificationFactory;
import org.sonar.server.issue.notification.NewIssuesStatistics;
import org.sonar.server.notification.NotificationService;

public class SendIssueNotificationsStep
implements ComputationStep {
    static final Set<String> NOTIF_TYPES = ImmutableSet.of((Object)"issue-changes", (Object)"new-issues", (Object)"my-new-issues");
    private final IssueCache issueCache;
    private final RuleRepository rules;
    private final TreeRootHolder treeRootHolder;
    private final NotificationService service;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final NewIssuesNotificationFactory newIssuesNotificationFactory;
    private final DbClient dbClient;
    private Map<String, Component> componentsByDbKey;

    public SendIssueNotificationsStep(IssueCache issueCache, RuleRepository rules, TreeRootHolder treeRootHolder, NotificationService service, AnalysisMetadataHolder analysisMetadataHolder, NewIssuesNotificationFactory newIssuesNotificationFactory, DbClient dbClient) {
        this.issueCache = issueCache;
        this.rules = rules;
        this.treeRootHolder = treeRootHolder;
        this.service = service;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.newIssuesNotificationFactory = newIssuesNotificationFactory;
        this.dbClient = dbClient;
    }

    @Override
    public void execute() {
        Component project = this.treeRootHolder.getRoot();
        if (this.service.hasProjectSubscribersForTypes(project.getUuid(), NOTIF_TYPES)) {
            this.doExecute(project);
        }
    }

    private void doExecute(Component project) {
        Map<String, UserDto> usersDtoByUuids;
        long analysisDate = this.analysisMetadataHolder.getAnalysisDate();
        Predicate<DefaultIssue> isOnLeakPredicate = i -> i.isNew() && i.creationDate().getTime() >= SendIssueNotificationsStep.truncateToSeconds(analysisDate);
        NewIssuesStatistics newIssuesStats = new NewIssuesStatistics(isOnLeakPredicate);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Iterable iterable = this.issueCache::traverse;
            List assigneeUuids = StreamSupport.stream(iterable.spliterator(), false).map(DefaultIssue::assignee).filter(Objects::nonNull).collect(Collectors.toList());
            usersDtoByUuids = this.dbClient.userDao().selectByUuids(dbSession, assigneeUuids).stream().collect(Collectors.toMap(UserDto::getUuid, dto -> dto));
        }
        var8_6 = null;
        try (CloseableIterator issues = this.issueCache.traverse();){
            this.processIssues(newIssuesStats, issues, project, usersDtoByUuids);
        }
        catch (Throwable throwable) {
            var8_6 = throwable;
            throw throwable;
        }
        if (newIssuesStats.hasIssuesOnLeak()) {
            this.sendNewIssuesNotification(newIssuesStats, project, analysisDate);
            this.sendNewIssuesNotificationToAssignees(newIssuesStats, project, analysisDate);
        }
    }

    private static long truncateToSeconds(long analysisDate) {
        Instant instant = new Date(analysisDate).toInstant();
        instant = instant.truncatedTo(ChronoUnit.SECONDS);
        return Date.from(instant).getTime();
    }

    private void processIssues(NewIssuesStatistics newIssuesStats, CloseableIterator<DefaultIssue> issues, Component project, Map<String, UserDto> usersDtoByUuids) {
        while (issues.hasNext()) {
            DefaultIssue issue = (DefaultIssue)issues.next();
            if (issue.isNew() && issue.resolution() == null) {
                newIssuesStats.add(issue);
                continue;
            }
            if (!issue.isChanged() || !issue.mustSendNotifications()) continue;
            this.sendIssueChangeNotification(issue, project, usersDtoByUuids);
        }
    }

    private void sendIssueChangeNotification(DefaultIssue issue, Component project, Map<String, UserDto> usersDtoByUuids) {
        IssueChangeNotification changeNotification = new IssueChangeNotification();
        changeNotification.setRuleName(this.rules.getByKey(issue.ruleKey()).getName());
        changeNotification.setIssue(issue);
        changeNotification.setAssignee(usersDtoByUuids.get(issue.assignee()));
        changeNotification.setProject(project.getPublicKey(), project.getName(), this.getBranchName(), this.getPullRequest());
        this.getComponentKey(issue).ifPresent(c -> changeNotification.setComponent(c.getPublicKey(), c.getName()));
        this.service.deliver(changeNotification);
    }

    private void sendNewIssuesNotification(NewIssuesStatistics statistics, Component project, long analysisDate) {
        NewIssuesStatistics.Stats globalStatistics = statistics.globalStatistics();
        NewIssuesNotification notification = this.newIssuesNotificationFactory.newNewIssuesNotification().setProject(project.getPublicKey(), project.getName(), this.getBranchName(), this.getPullRequest()).setProjectVersion(project.getReportAttributes().getVersion()).setAnalysisDate(new Date(analysisDate)).setStatistics(project.getName(), globalStatistics).setDebt(Duration.create((long)globalStatistics.effort().getOnLeak()));
        this.service.deliver(notification);
    }

    private void sendNewIssuesNotificationToAssignees(NewIssuesStatistics statistics, Component project, long analysisDate) {
        Map<String, UserDto> userDtoByUuid = this.loadUserDtoByUuid(statistics);
        statistics.getAssigneesStatistics().entrySet().stream().filter(e -> ((NewIssuesStatistics.Stats)e.getValue()).hasIssuesOnLeak()).forEach(e -> {
            String assigneeUuid = (String)e.getKey();
            NewIssuesStatistics.Stats assigneeStatistics = (NewIssuesStatistics.Stats)e.getValue();
            MyNewIssuesNotification myNewIssuesNotification = this.newIssuesNotificationFactory.newMyNewIssuesNotification().setAssignee((UserDto)userDtoByUuid.get(assigneeUuid));
            myNewIssuesNotification.setProject(project.getPublicKey(), project.getName(), this.getBranchName(), this.getPullRequest()).setProjectVersion(project.getReportAttributes().getVersion()).setAnalysisDate(new Date(analysisDate)).setStatistics(project.getName(), assigneeStatistics).setDebt(Duration.create((long)assigneeStatistics.effort().getOnLeak()));
            this.service.deliver(myNewIssuesNotification);
        });
    }

    private Map<String, UserDto> loadUserDtoByUuid(NewIssuesStatistics statistics) {
        List entriesWithIssuesOnLeak = statistics.getAssigneesStatistics().entrySet().stream().filter(e -> ((NewIssuesStatistics.Stats)e.getValue()).hasIssuesOnLeak()).collect(Collectors.toList());
        List assigneeUuids = entriesWithIssuesOnLeak.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Map<String, UserDto> map = this.dbClient.userDao().selectByUuids(dbSession, assigneeUuids).stream().collect(Collectors.toMap(UserDto::getUuid, u -> u));
            return map;
        }
    }

    private Optional<Component> getComponentKey(DefaultIssue issue) {
        if (this.componentsByDbKey == null) {
            final ImmutableMap.Builder builder = ImmutableMap.builder();
            new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.LEAVES, ComponentVisitor.Order.POST_ORDER){

                @Override
                public void visitAny(Component component) {
                    builder.put((Object)component.getKey(), (Object)component);
                }
            }).visit(this.treeRootHolder.getRoot());
            this.componentsByDbKey = builder.build();
        }
        return Optional.ofNullable(this.componentsByDbKey.get(issue.componentKey()));
    }

    @Override
    public String getDescription() {
        return "Send issue notifications";
    }

    @CheckForNull
    private String getBranchName() {
        Branch branch = this.analysisMetadataHolder.getBranch();
        return branch.isMain() || branch.getType() == BranchType.PULL_REQUEST ? null : branch.getName();
    }

    @CheckForNull
    private String getPullRequest() {
        Branch branch = this.analysisMetadataHolder.getBranch();
        return branch.getType() == BranchType.PULL_REQUEST ? this.analysisMetadataHolder.getPullRequestKey() : null;
    }
}

