/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.SnapshotDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.period.Period;
import org.sonar.server.computation.task.projectanalysis.period.PeriodHolder;
import org.sonar.server.computation.task.step.ComputationStep;

public class PersistAnalysisStep
implements ComputationStep {
    private final System2 system2;
    private final DbClient dbClient;
    private final TreeRootHolder treeRootHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final PeriodHolder periodHolder;

    public PersistAnalysisStep(System2 system2, DbClient dbClient, TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder, PeriodHolder periodHolder) {
        this.system2 = system2;
        this.dbClient = dbClient;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.periodHolder = periodHolder;
    }

    @Override
    public void execute() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            new DepthTraversalTypeAwareCrawler(new PersistSnapshotsPathAwareVisitor(dbSession, this.analysisMetadataHolder.getAnalysisDate())).visit(this.treeRootHolder.getRoot());
            dbSession.commit();
        }
    }

    @Override
    public String getDescription() {
        return "Persist analysis";
    }

    private class PersistSnapshotsPathAwareVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession dbSession;
        private final long analysisDate;

        public PersistSnapshotsPathAwareVisitor(DbSession dbSession, long analysisDate) {
            super(CrawlerDepthLimit.ROOTS, ComponentVisitor.Order.PRE_ORDER);
            this.dbSession = dbSession;
            this.analysisDate = analysisDate;
        }

        @Override
        public void visitProject(Component project) {
            SnapshotDto snapshot = this.createAnalysis(PersistAnalysisStep.this.analysisMetadataHolder.getUuid(), project, true);
            this.updateSnapshotPeriods(snapshot);
            this.persist(snapshot, this.dbSession);
        }

        @Override
        public void visitView(Component view) {
            SnapshotDto snapshot = this.createAnalysis(PersistAnalysisStep.this.analysisMetadataHolder.getUuid(), view, false);
            this.updateSnapshotPeriods(snapshot);
            this.persist(snapshot, this.dbSession);
        }

        private void updateSnapshotPeriods(SnapshotDto snapshotDto) {
            if (!PersistAnalysisStep.this.periodHolder.hasPeriod()) {
                return;
            }
            Period period = PersistAnalysisStep.this.periodHolder.getPeriod();
            snapshotDto.setPeriodMode(period.getMode());
            snapshotDto.setPeriodParam(period.getModeParameter());
            snapshotDto.setPeriodDate(Long.valueOf(period.getSnapshotDate()));
        }

        private SnapshotDto createAnalysis(String snapshotUuid, Component component, boolean setVersion) {
            String componentUuid = component.getUuid();
            return new SnapshotDto().setUuid(snapshotUuid).setVersion(setVersion ? component.getReportAttributes().getVersion() : null).setComponentUuid(componentUuid).setLast(Boolean.valueOf(false)).setStatus("U").setCreatedAt(Long.valueOf(this.analysisDate)).setBuildDate(Long.valueOf(PersistAnalysisStep.this.system2.now()));
        }

        private void persist(SnapshotDto snapshotDto, DbSession dbSession) {
            PersistAnalysisStep.this.dbClient.snapshotDao().insert(dbSession, snapshotDto);
        }
    }
}

