/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source.linereader;

import org.sonar.scanner.protocol.output.ScannerReport;

public class RangeOffsetConverter {
    static final String OFFSET_SEPARATOR = ",";
    static final String SYMBOLS_SEPARATOR = ";";

    public String offsetToString(ScannerReport.TextRange range, int lineIndex, int lineLength) {
        RangeOffsetConverter.validateOffsetOrder(range, lineIndex);
        RangeOffsetConverter.validateStartOffsetNotGreaterThanLineLength(range, lineLength, lineIndex);
        RangeOffsetConverter.validateEndOffsetNotGreaterThanLineLength(range, lineLength, lineIndex);
        int startOffset = range.getStartLine() == lineIndex ? range.getStartOffset() : 0;
        int endOffset = range.getEndLine() == lineIndex ? range.getEndOffset() : lineLength;
        StringBuilder element = new StringBuilder();
        if (startOffset < endOffset) {
            element.append(startOffset).append(OFFSET_SEPARATOR);
            element.append(endOffset);
        }
        return element.toString();
    }

    private static void validateOffsetOrder(ScannerReport.TextRange range, int line) {
        RangeOffsetConverter.checkExpression(range.getStartLine() != range.getEndLine() || range.getStartOffset() <= range.getEndOffset(), "End offset %s cannot be defined before start offset %s on line %s", range.getEndOffset(), range.getStartOffset(), line);
    }

    private static void validateStartOffsetNotGreaterThanLineLength(ScannerReport.TextRange range, int lineLength, int line) {
        RangeOffsetConverter.checkExpression(range.getStartLine() != line || range.getStartOffset() <= lineLength, "Start offset %s is defined outside the length (%s) of the line %s", range.getStartOffset(), lineLength, line);
    }

    private static void validateEndOffsetNotGreaterThanLineLength(ScannerReport.TextRange range, int lineLength, int line) {
        RangeOffsetConverter.checkExpression(range.getEndLine() != line || range.getEndOffset() <= lineLength, "End offset %s is defined outside the length (%s) of the line %s", range.getEndOffset(), lineLength, line);
    }

    private static void checkExpression(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new RangeOffsetConverterException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static class RangeOffsetConverterException
    extends RuntimeException {
        public RangeOffsetConverterException(String message) {
            super(message);
        }
    }
}

