/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.scm;

import java.util.Optional;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.source.FileSourceDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.analysis.Branch;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.MergeBranchComponentUuids;
import org.sonar.server.computation.task.projectanalysis.scm.DbScmInfo;

public class ScmInfoDbLoader {
    private static final Logger LOGGER = Loggers.get(ScmInfoDbLoader.class);
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final DbClient dbClient;
    private final MergeBranchComponentUuids mergeBranchComponentUuid;

    public ScmInfoDbLoader(AnalysisMetadataHolder analysisMetadataHolder, DbClient dbClient, MergeBranchComponentUuids mergeBranchComponentUuid) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.dbClient = dbClient;
        this.mergeBranchComponentUuid = mergeBranchComponentUuid;
    }

    public Optional<DbScmInfo> getScmInfo(Component file) {
        Optional<String> uuid = this.getFileUUid(file);
        if (!uuid.isPresent()) {
            return Optional.empty();
        }
        LOGGER.trace("Reading SCM info from DB for file '{}'", (Object)uuid.get());
        try (DbSession dbSession = this.dbClient.openSession(false);){
            FileSourceDto dto = this.dbClient.fileSourceDao().selectSourceByFileUuid(dbSession, uuid.get());
            if (dto == null) {
                Optional<DbScmInfo> optional = Optional.empty();
                return optional;
            }
            Optional<DbScmInfo> optional = DbScmInfo.create(dto.getSourceData().getLinesList(), dto.getSrcHash());
            return optional;
        }
    }

    private Optional<String> getFileUUid(Component file) {
        if (!this.analysisMetadataHolder.isFirstAnalysis()) {
            return Optional.of(file.getUuid());
        }
        Branch branch = this.analysisMetadataHolder.getBranch();
        if (branch.getMergeBranchUuid().isPresent()) {
            return Optional.ofNullable(this.mergeBranchComponentUuid.getUuid(file.getKey()));
        }
        return Optional.empty();
    }
}

