/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.issue.ShortBranchIssueDto;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ShortBranchComponentsWithIssues;
import org.sonar.server.computation.task.projectanalysis.issue.ComponentIssuesLoader;
import org.sonar.server.computation.task.projectanalysis.issue.ShortBranchIssue;

public class ShortBranchIssuesLoader {
    private final ShortBranchComponentsWithIssues shortBranchComponentsWithIssues;
    private final DbClient dbClient;

    public ShortBranchIssuesLoader(ShortBranchComponentsWithIssues shortBranchComponentsWithIssues, DbClient dbClient) {
        this.shortBranchComponentsWithIssues = shortBranchComponentsWithIssues;
        this.dbClient = dbClient;
    }

    public Collection<ShortBranchIssue> loadCandidateIssuesForMergingInTargetBranch(Component component) {
        String componentKey = ComponentDto.removeBranchAndPullRequestFromKey((String)component.getKey());
        Set<String> uuids = this.shortBranchComponentsWithIssues.getUuids(componentKey);
        if (uuids.isEmpty()) {
            return Collections.emptyList();
        }
        try (DbSession session = this.dbClient.openSession(false);){
            Collection collection = this.dbClient.issueDao().selectOpenByComponentUuids(session, uuids).stream().map(ShortBranchIssuesLoader::toShortBranchIssue).collect(Collectors.toList());
            return collection;
        }
    }

    private static ShortBranchIssue toShortBranchIssue(ShortBranchIssueDto dto) {
        return new ShortBranchIssue(dto.getKey(), dto.getLine(), dto.getMessage(), dto.getChecksum(), dto.getRuleKey(), dto.getStatus(), dto.getBranchName(), DateUtils.longToDate((Long)dto.getIssueCreationDate()));
    }

    public Map<ShortBranchIssue, DefaultIssue> loadDefaultIssuesWithChanges(Collection<ShortBranchIssue> lightIssues) {
        if (lightIssues.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, ShortBranchIssue> issuesByKey = lightIssues.stream().collect(Collectors.toMap(ShortBranchIssue::getKey, i -> i));
        try (DbSession session = this.dbClient.openSession(false);){
            Map<String, List<IssueChangeDto>> changeDtoByIssueKey = this.dbClient.issueChangeDao().selectByIssueKeys(session, issuesByKey.keySet()).stream().collect(Collectors.groupingBy(IssueChangeDto::getIssueKey));
            Map<ShortBranchIssue, DefaultIssue> map = this.dbClient.issueDao().selectByKeys(session, issuesByKey.keySet()).stream().map(IssueDto::toDefaultIssue).peek(i -> ComponentIssuesLoader.setChanges(changeDtoByIssueKey, i)).collect(Collectors.toMap(i -> (ShortBranchIssue)issuesByKey.get(i.key()), i -> i));
            return map;
        }
    }
}

