/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import java.util.Collections;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Tracking;
import org.sonar.db.component.BranchType;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.analysis.Branch;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.MergeBranchTrackerExecution;
import org.sonar.server.computation.task.projectanalysis.issue.ShortBranchTrackerExecution;
import org.sonar.server.computation.task.projectanalysis.issue.TrackerExecution;
import org.sonar.server.computation.task.projectanalysis.issue.TrackingResult;

public class IssueTrackingDelegator {
    private final ShortBranchTrackerExecution shortBranchTracker;
    private final TrackerExecution tracker;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final MergeBranchTrackerExecution mergeBranchTracker;

    public IssueTrackingDelegator(ShortBranchTrackerExecution shortBranchTracker, MergeBranchTrackerExecution longBranchTracker, TrackerExecution tracker, AnalysisMetadataHolder analysisMetadataHolder) {
        this.shortBranchTracker = shortBranchTracker;
        this.mergeBranchTracker = longBranchTracker;
        this.tracker = tracker;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    public TrackingResult track(Component component) {
        if (this.analysisMetadataHolder.isShortLivingBranch() || this.analysisMetadataHolder.isPullRequest()) {
            return IssueTrackingDelegator.standardResult(this.shortBranchTracker.track(component));
        }
        if (this.isFirstAnalysisSecondaryLongLivingBranch()) {
            Tracking<DefaultIssue, DefaultIssue> tracking = this.mergeBranchTracker.track(component);
            return new TrackingResult(tracking.getMatchedRaws(), Collections.emptyMap(), Collections.emptyList(), tracking.getUnmatchedRaws());
        }
        return IssueTrackingDelegator.standardResult(this.tracker.track(component));
    }

    private static TrackingResult standardResult(Tracking<DefaultIssue, DefaultIssue> tracking) {
        return new TrackingResult(Collections.emptyMap(), tracking.getMatchedRaws(), tracking.getUnmatchedBases(), tracking.getUnmatchedRaws());
    }

    private boolean isFirstAnalysisSecondaryLongLivingBranch() {
        if (this.analysisMetadataHolder.isFirstAnalysis()) {
            Branch branch = this.analysisMetadataHolder.getBranch();
            return !branch.isMain() && branch.getType() == BranchType.LONG;
        }
        return false;
    }
}

