/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.formula.coverage;

import com.google.common.base.Optional;
import org.sonar.server.computation.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.server.computation.task.projectanalysis.formula.Formula;
import org.sonar.server.computation.task.projectanalysis.formula.counter.LongValue;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.CoverageUtils;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.ElementsAndCoveredElementsVariationCounter;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;

public abstract class CoverageVariationFormula<T extends ElementsAndCoveredElementsVariationCounter>
implements Formula<T> {
    @Override
    public Optional<Measure> createMeasure(T counter, CreateMeasureContext context) {
        LongValue elements = ((ElementsAndCoveredElementsVariationCounter)counter).elements;
        if (elements.isSet() && (double)elements.getValue() > 0.0) {
            LongValue coveredElements = ((ElementsAndCoveredElementsVariationCounter)counter).coveredElements;
            double variation = CoverageUtils.calculateCoverage(coveredElements.getValue(), elements.getValue());
            return Optional.of((Object)Measure.newMeasureBuilder().setVariation(variation).createNoValue());
        }
        return Optional.absent();
    }
}

