/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.logs.Profiler;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentCrawler;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitorWrapper;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitor;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorWrapper;
import org.sonar.server.computation.task.projectanalysis.component.VisitException;
import org.sonar.server.computation.task.projectanalysis.component.VisitorWrapper;

public class VisitorsCrawler
implements ComponentCrawler {
    private final boolean computeDuration;
    private final Map<ComponentVisitor, VisitorDuration> visitorCumulativeDurations;
    private final List<VisitorWrapper> preOrderVisitorWrappers;
    private final List<VisitorWrapper> postOrderVisitorWrappers;

    public VisitorsCrawler(Iterable<ComponentVisitor> visitors) {
        this(visitors, false);
    }

    public VisitorsCrawler(Iterable<ComponentVisitor> visitors, boolean computeDuration) {
        ImmutableList visitorWrappers = FluentIterable.from(visitors).transform((Function)ToVisitorWrapper.INSTANCE).toList();
        this.preOrderVisitorWrappers = FluentIterable.from((Iterable)visitorWrappers).filter((Predicate)MathPreOrderVisitor.INSTANCE).toList();
        this.postOrderVisitorWrappers = FluentIterable.from((Iterable)visitorWrappers).filter((Predicate)MatchPostOrderVisitor.INSTANCE).toList();
        this.computeDuration = computeDuration;
        this.visitorCumulativeDurations = computeDuration ? FluentIterable.from(visitors).toMap((Function)VisitorWrapperToInitialDuration.INSTANCE) : Collections.emptyMap();
    }

    public Map<ComponentVisitor, Long> getCumulativeDurations() {
        if (this.computeDuration) {
            return ImmutableMap.copyOf((Map)Maps.transformValues(this.visitorCumulativeDurations, (Function)VisitorDurationToDuration.INSTANCE));
        }
        return Collections.emptyMap();
    }

    @Override
    public void visit(Component component) {
        try {
            this.visitImpl(component);
        }
        catch (RuntimeException e) {
            VisitException.rethrowOrWrap(e, "Visit of Component {key=%s,type=%s} failed", new Object[]{component.getKey(), component.getType()});
        }
    }

    private void visitImpl(Component component) {
        MatchVisitorMaxDepth visitorMaxDepth = MatchVisitorMaxDepth.forComponent(component);
        ImmutableList preOrderVisitorWrappersToExecute = FluentIterable.from(this.preOrderVisitorWrappers).filter((Predicate)visitorMaxDepth).toList();
        ImmutableList postOrderVisitorWrappersToExecute = FluentIterable.from(this.postOrderVisitorWrappers).filter((Predicate)visitorMaxDepth).toList();
        if (preOrderVisitorWrappersToExecute.isEmpty() && postOrderVisitorWrappersToExecute.isEmpty()) {
            return;
        }
        for (VisitorWrapper visitorWrapper : Iterables.concat(this.preOrderVisitorWrappers, this.postOrderVisitorWrappers)) {
            visitorWrapper.beforeComponent(component);
        }
        for (VisitorWrapper visitorWrapper : preOrderVisitorWrappersToExecute) {
            this.visitNode(component, visitorWrapper);
        }
        this.visitChildren(component);
        for (VisitorWrapper visitorWrapper : postOrderVisitorWrappersToExecute) {
            this.visitNode(component, visitorWrapper);
        }
        for (VisitorWrapper visitorWrapper : Iterables.concat((Iterable)preOrderVisitorWrappersToExecute, (Iterable)postOrderVisitorWrappersToExecute)) {
            visitorWrapper.afterComponent(component);
        }
    }

    private void visitChildren(Component component) {
        for (Component child : component.getChildren()) {
            this.visit(child);
        }
    }

    private void visitNode(Component component, VisitorWrapper visitor) {
        Profiler profiler = Profiler.create((Logger)Loggers.get(visitor.getWrappedVisitor().getClass())).startTrace("Visiting component {}", new Object[]{component.getKey()});
        visitor.visitAny(component);
        switch (component.getType()) {
            case PROJECT: {
                visitor.visitProject(component);
                break;
            }
            case MODULE: {
                visitor.visitModule(component);
                break;
            }
            case DIRECTORY: {
                visitor.visitDirectory(component);
                break;
            }
            case FILE: {
                visitor.visitFile(component);
                break;
            }
            case VIEW: {
                visitor.visitView(component);
                break;
            }
            case SUBVIEW: {
                visitor.visitSubView(component);
                break;
            }
            case PROJECT_VIEW: {
                visitor.visitProjectView(component);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown type %s", component.getType().name()));
            }
        }
        long duration = profiler.stopTrace();
        this.incrementDuration(visitor, duration);
    }

    private void incrementDuration(VisitorWrapper visitorWrapper, long duration) {
        if (this.computeDuration) {
            this.visitorCumulativeDurations.get(visitorWrapper.getWrappedVisitor()).increment(duration);
        }
    }

    private static enum VisitorDurationToDuration implements Function<VisitorDuration, Long>
    {
        INSTANCE;


        @Nullable
        public Long apply(VisitorDuration input) {
            return input.getDuration();
        }
    }

    private static enum VisitorWrapperToInitialDuration implements Function<ComponentVisitor, VisitorDuration>
    {
        INSTANCE;


        @Nonnull
        public VisitorDuration apply(@Nonnull ComponentVisitor visitorWrapper) {
            return new VisitorDuration();
        }
    }

    private static final class VisitorDuration {
        private long duration = 0L;

        private VisitorDuration() {
        }

        public void increment(long duration) {
            this.duration += duration;
        }

        public long getDuration() {
            return this.duration;
        }
    }

    private static enum MatchPostOrderVisitor implements Predicate<VisitorWrapper>
    {
        INSTANCE;


        public boolean apply(@Nonnull VisitorWrapper visitorWrapper) {
            return visitorWrapper.getOrder() == ComponentVisitor.Order.POST_ORDER;
        }
    }

    private static enum MathPreOrderVisitor implements Predicate<VisitorWrapper>
    {
        INSTANCE;


        public boolean apply(@Nonnull VisitorWrapper visitorWrapper) {
            return visitorWrapper.getOrder() == ComponentVisitor.Order.PRE_ORDER;
        }
    }

    private static class MatchVisitorMaxDepth
    implements Predicate<VisitorWrapper> {
        private static final Map<Component.Type, MatchVisitorMaxDepth> INSTANCES = MatchVisitorMaxDepth.buildInstances();
        private final Component.Type type;

        private MatchVisitorMaxDepth(Component.Type type) {
            this.type = Objects.requireNonNull(type);
        }

        private static Map<Component.Type, MatchVisitorMaxDepth> buildInstances() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Component.Type type : Component.Type.values()) {
                builder.put((Object)type, (Object)new MatchVisitorMaxDepth(type));
            }
            return builder.build();
        }

        public static MatchVisitorMaxDepth forComponent(Component component) {
            return INSTANCES.get((Object)component.getType());
        }

        public boolean apply(@Nonnull VisitorWrapper visitorWrapper) {
            CrawlerDepthLimit maxDepth = visitorWrapper.getMaxDepth();
            return maxDepth.isSameAs(this.type) || maxDepth.isDeeperThan(this.type);
        }
    }

    private static enum ToVisitorWrapper implements Function<ComponentVisitor, VisitorWrapper>
    {
        INSTANCE;


        public VisitorWrapper apply(@Nonnull ComponentVisitor componentVisitor) {
            if (componentVisitor instanceof TypeAwareVisitor) {
                return new TypeAwareVisitorWrapper((TypeAwareVisitor)componentVisitor);
            }
            if (componentVisitor instanceof PathAwareVisitor) {
                return new PathAwareVisitorWrapper((PathAwareVisitor)componentVisitor);
            }
            throw new IllegalArgumentException("Only TypeAwareVisitor and PathAwareVisitor can be used");
        }
    }
}

