/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.ce.queue.CeQueue;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.user.UserSession;

public class CancelAllAction
implements CeWsAction {
    private final UserSession userSession;
    private final CeQueue queue;

    public CancelAllAction(UserSession userSession, CeQueue queue) {
        this.userSession = userSession;
        this.queue = queue;
    }

    @Override
    public void define(WebService.NewController controller) {
        controller.createAction("cancel_all").setDescription("Cancels all pending tasks. Requires system administration permission. In-progress tasks are not canceled.").setInternal(true).setPost(true).setSince("5.2").setHandler((RequestHandler)this);
    }

    public void handle(Request wsRequest, Response wsResponse) {
        this.userSession.checkIsSystemAdministrator();
        this.queue.cancelAll();
        wsResponse.noContent();
    }
}

