/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication.exception;

import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.AuthenticationRedirection;
import org.sonar.server.authentication.exception.RedirectionException;

public class UpdateLoginRedirectionException
extends RedirectionException {
    private static final String PATH = "/sessions/update_login?login=%s&providerKey=%s&providerName=%s&oldLogin=%s&oldOrganizationKey=%s";
    private final UserIdentity userIdentity;
    private final IdentityProvider provider;
    private final UserDto user;
    private final OrganizationDto organization;

    public UpdateLoginRedirectionException(UserIdentity userIdentity, IdentityProvider provider, UserDto user, OrganizationDto organization) {
        this.userIdentity = userIdentity;
        this.provider = provider;
        this.user = user;
        this.organization = organization;
    }

    @Override
    public String getPath(String contextPath) {
        return contextPath + String.format(PATH, AuthenticationRedirection.encodeMessage(this.userIdentity.getProviderLogin()), AuthenticationRedirection.encodeMessage(this.provider.getKey()), AuthenticationRedirection.encodeMessage(this.provider.getName()), AuthenticationRedirection.encodeMessage(this.user.getLogin()), AuthenticationRedirection.encodeMessage(this.organization.getKey()));
    }
}

