/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.util.Objects;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.server.authentication.event.AuthenticationEvent;

class UserIdentityAuthenticatorParameters {
    private final UserIdentity userIdentity;
    private final IdentityProvider provider;
    private final AuthenticationEvent.Source source;
    private final ExistingEmailStrategy existingEmailStrategy;
    private final UpdateLoginStrategy updateLoginStrategy;

    UserIdentityAuthenticatorParameters(Builder builder) {
        this.userIdentity = builder.userIdentity;
        this.provider = builder.provider;
        this.source = builder.source;
        this.existingEmailStrategy = builder.existingEmailStrategy;
        this.updateLoginStrategy = builder.updateLoginStrategy;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public IdentityProvider getProvider() {
        return this.provider;
    }

    public AuthenticationEvent.Source getSource() {
        return this.source;
    }

    public ExistingEmailStrategy getExistingEmailStrategy() {
        return this.existingEmailStrategy;
    }

    public UpdateLoginStrategy getUpdateLoginStrategy() {
        return this.updateLoginStrategy;
    }

    static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private UserIdentity userIdentity;
        private IdentityProvider provider;
        private AuthenticationEvent.Source source;
        private ExistingEmailStrategy existingEmailStrategy;
        private UpdateLoginStrategy updateLoginStrategy;

        public Builder setUserIdentity(UserIdentity userIdentity) {
            this.userIdentity = userIdentity;
            return this;
        }

        public Builder setProvider(IdentityProvider provider) {
            this.provider = provider;
            return this;
        }

        public Builder setSource(AuthenticationEvent.Source source) {
            this.source = source;
            return this;
        }

        public Builder setExistingEmailStrategy(ExistingEmailStrategy existingEmailStrategy) {
            this.existingEmailStrategy = existingEmailStrategy;
            return this;
        }

        public Builder setUpdateLoginStrategy(UpdateLoginStrategy updateLoginStrategy) {
            this.updateLoginStrategy = updateLoginStrategy;
            return this;
        }

        public UserIdentityAuthenticatorParameters build() {
            Objects.requireNonNull(this.userIdentity, "userIdentity must be set");
            Objects.requireNonNull(this.provider, "identityProvider must be set");
            Objects.requireNonNull(this.source, "Source must be set");
            Objects.requireNonNull(this.existingEmailStrategy, "existingEmailStrategy must be set ");
            Objects.requireNonNull(this.updateLoginStrategy, "updateLoginStrategy must be set");
            return new UserIdentityAuthenticatorParameters(this);
        }
    }

    static enum UpdateLoginStrategy {
        ALLOW,
        WARN;

    }

    static enum ExistingEmailStrategy {
        ALLOW,
        WARN,
        FORBID;

    }
}

