/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.async;

import java.util.Objects;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.async.AsyncExecution;
import org.sonar.server.async.AsyncExecutionExecutorService;

public class AsyncExecutionImpl
implements AsyncExecution {
    private static final Logger LOG = Loggers.get(AsyncExecutionImpl.class);
    private final AsyncExecutionExecutorService executorService;

    public AsyncExecutionImpl(AsyncExecutionExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void addToQueue(Runnable r) {
        Objects.requireNonNull(r);
        this.executorService.addToQueue(() -> {
            try {
                r.run();
            }
            catch (Exception e) {
                LOG.error("Asynchronous task failed", (Throwable)e);
            }
        });
    }
}

