/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.http;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.ce.http.CeHttpClient;
import org.sonar.process.ProcessId;
import org.sonar.process.sharedmemoryfile.DefaultProcessCommands;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;

public class CeHttpClientImpl
implements CeHttpClient {
    private static final String PATH_CHANGE_LOG_LEVEL = "changeLogLevel";
    private static final String PATH_SYSTEM_INFO = "systemInfo";
    private final File ipcSharedDir;

    public CeHttpClientImpl(Configuration config) {
        this.ipcSharedDir = new File((String)config.get("process.sharedDir").get());
    }

    @Override
    public Optional<ProtobufSystemInfo.SystemInfo> retrieveSystemInfo() {
        return this.call(SystemInfoActionClient.INSTANCE);
    }

    @Override
    public void changeLogLevel(LoggerLevel level) {
        Objects.requireNonNull(level, "level can't be null");
        this.call(new ChangeLogLevelActionClient(level));
    }

    @Override
    public void refreshCeWorkerCount() {
        this.call(RefreshCeWorkerCountActionClient.INSTANCE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T call(ActionClient<T> actionClient) {
        try (DefaultProcessCommands commands = DefaultProcessCommands.secondary((File)this.ipcSharedDir, (int)ProcessId.COMPUTE_ENGINE.getIpcIndex());){
            if (commands.isUp()) {
                T t = actionClient.call(commands.getHttpUrl() + "/" + actionClient.getPath());
                return t;
            }
            T t = actionClient.getDefault();
            return t;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to call HTTP server of process " + ProcessId.COMPUTE_ENGINE, e);
        }
    }

    private static interface ActionClient<T> {
        public String getPath();

        public T getDefault();

        public T call(String var1) throws Exception;
    }

    private static enum RefreshCeWorkerCountActionClient implements ActionClient<Void>
    {
        INSTANCE;


        @Override
        public String getPath() {
            return "refreshWorkerCount";
        }

        @Override
        public Void getDefault() {
            return null;
        }

        @Override
        public Void call(String url) throws Exception {
            Request request = new Request.Builder().post(RequestBody.create(null, (byte[])new byte[0])).url(url).build();
            try (Response response = new OkHttpClient().newCall(request).execute();){
                if (response.code() != 200) {
                    throw new IOException(String.format("Failed to trigger refresh of CE Worker count. Code was '%s' and response was '%s' for url '%s'", response.code(), response.body().string(), url));
                }
                Void void_ = null;
                return void_;
            }
        }
    }

    private static final class ChangeLogLevelActionClient
    implements ActionClient<Void> {
        private final LoggerLevel newLogLevel;

        private ChangeLogLevelActionClient(LoggerLevel newLogLevel) {
            this.newLogLevel = newLogLevel;
        }

        @Override
        public String getPath() {
            return CeHttpClientImpl.PATH_CHANGE_LOG_LEVEL;
        }

        @Override
        public Void getDefault() {
            return null;
        }

        @Override
        public Void call(String url) throws Exception {
            Request request = new Request.Builder().post(RequestBody.create(null, (byte[])new byte[0])).url(url + "?level=" + this.newLogLevel.name()).build();
            try (Response response = new OkHttpClient().newCall(request).execute();){
                if (response.code() != 200) {
                    throw new IOException(String.format("Failed to change log level in Compute Engine. Code was '%s' and response was '%s' for url '%s'", response.code(), response.body().string(), url));
                }
                Void void_ = null;
                return void_;
            }
        }
    }

    private static enum SystemInfoActionClient implements ActionClient<Optional<ProtobufSystemInfo.SystemInfo>>
    {
        INSTANCE;


        @Override
        public String getPath() {
            return CeHttpClientImpl.PATH_SYSTEM_INFO;
        }

        @Override
        public Optional<ProtobufSystemInfo.SystemInfo> getDefault() {
            return Optional.empty();
        }

        @Override
        public Optional<ProtobufSystemInfo.SystemInfo> call(String url) throws Exception {
            byte[] protobuf = IOUtils.toByteArray((URI)new URI(url));
            return Optional.of(ProtobufSystemInfo.SystemInfo.parseFrom((byte[])protobuf));
        }
    }
}

