/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.sonar.api.i18n.I18n;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.WebService;

public class WsParameterBuilder {
    private static final String PARAM_QUALIFIER = "qualifier";
    private static final String PARAM_QUALIFIERS = "qualifiers";

    private WsParameterBuilder() {
    }

    public static WebService.NewParam createRootQualifierParameter(WebService.NewAction action, QualifierParameterContext context) {
        return action.createParam(PARAM_QUALIFIER).setDescription("Project qualifier. Filter the results with the specified qualifier. Possible values are:" + WsParameterBuilder.buildRootQualifiersDescription(context)).setPossibleValues(WsParameterBuilder.getRootQualifiers(context.getResourceTypes()));
    }

    public static WebService.NewParam createRootQualifiersParameter(WebService.NewAction action, QualifierParameterContext context) {
        return action.createParam(PARAM_QUALIFIERS).setDescription("Comma-separated list of component qualifiers. Filter the results with the specified qualifiers. Possible values are:" + WsParameterBuilder.buildRootQualifiersDescription(context)).setPossibleValues(WsParameterBuilder.getRootQualifiers(context.getResourceTypes()));
    }

    public static WebService.NewParam createDefaultTemplateQualifierParameter(WebService.NewAction action, QualifierParameterContext context) {
        return action.createParam(PARAM_QUALIFIER).setDescription("Project qualifier. Filter the results with the specified qualifier. Possible values are:" + WsParameterBuilder.buildDefaultTemplateQualifiersDescription(context)).setPossibleValues(WsParameterBuilder.getDefaultTemplateQualifiers(context.getResourceTypes()));
    }

    public static WebService.NewParam createQualifiersParameter(WebService.NewAction action, QualifierParameterContext context) {
        return action.createParam(PARAM_QUALIFIERS).setDescription("Comma-separated list of component qualifiers. Filter the results with the specified qualifiers. Possible values are:" + WsParameterBuilder.buildAllQualifiersDescription(context)).setPossibleValues(WsParameterBuilder.getAllQualifiers(context.getResourceTypes()));
    }

    private static Set<String> getRootQualifiers(ResourceTypes resourceTypes) {
        return resourceTypes.getRoots().stream().map(ResourceType::getQualifier).collect(Collectors.toCollection(TreeSet::new));
    }

    private static Set<String> getDefaultTemplateQualifiers(ResourceTypes resourceTypes) {
        return resourceTypes.getRoots().stream().map(ResourceType::getQualifier).filter(q -> !"APP".equals(q)).collect(Collectors.toCollection(TreeSet::new));
    }

    private static Set<String> getAllQualifiers(ResourceTypes resourceTypes) {
        return resourceTypes.getAll().stream().map(ResourceType::getQualifier).collect(Collectors.toCollection(TreeSet::new));
    }

    private static String buildDefaultTemplateQualifiersDescription(QualifierParameterContext context) {
        return WsParameterBuilder.buildQualifiersDescription(context, WsParameterBuilder.getDefaultTemplateQualifiers(context.getResourceTypes()));
    }

    private static String buildRootQualifiersDescription(QualifierParameterContext context) {
        return WsParameterBuilder.buildQualifiersDescription(context, WsParameterBuilder.getRootQualifiers(context.getResourceTypes()));
    }

    private static String buildAllQualifiersDescription(QualifierParameterContext context) {
        return WsParameterBuilder.buildQualifiersDescription(context, WsParameterBuilder.getAllQualifiers(context.getResourceTypes()));
    }

    private static String buildQualifiersDescription(QualifierParameterContext context, Set<String> qualifiers) {
        StringBuilder description = new StringBuilder();
        description.append("<ul>");
        String qualifierPattern = "<li>%s - %s</li>";
        for (String qualifier : qualifiers) {
            description.append(String.format(qualifierPattern, qualifier, WsParameterBuilder.qualifierLabel(context, qualifier)));
        }
        description.append("</ul>");
        return description.toString();
    }

    private static String qualifierLabel(QualifierParameterContext context, String qualifier) {
        String qualifiersPropertyPrefix = "qualifiers.";
        return context.getI18n().message(Locale.ENGLISH, qualifiersPropertyPrefix + qualifier, "no description available", new Object[0]);
    }

    public static class QualifierParameterContext {
        private final I18n i18n;
        private final ResourceTypes resourceTypes;

        private QualifierParameterContext(I18n i18n, ResourceTypes resourceTypes) {
            this.i18n = i18n;
            this.resourceTypes = resourceTypes;
        }

        public static QualifierParameterContext newQualifierParameterContext(I18n i18n, ResourceTypes resourceTypes) {
            return new QualifierParameterContext(i18n, resourceTypes);
        }

        public I18n getI18n() {
            return this.i18n;
        }

        public ResourceTypes getResourceTypes() {
            return this.resourceTypes;
        }
    }
}

