/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.ws.LocalConnector;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.server.ws.internal.ValidatingRequest;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.exceptions.ServerException;
import org.sonar.server.ws.DefaultLocalResponse;
import org.sonar.server.ws.LocalRequestAdapter;
import org.sonar.server.ws.RequestVerifier;
import org.sonar.server.ws.ServletRequest;
import org.sonar.server.ws.ServletResponse;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class WebServiceEngine
implements LocalConnector,
Startable {
    private static final Logger LOGGER = Loggers.get(WebServiceEngine.class);
    private final WebService.Context context = new WebService.Context();

    public WebServiceEngine(WebService[] webServices) {
        for (WebService webService : webServices) {
            webService.define(this.context);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    List<WebService.Controller> controllers() {
        return this.context.controllers();
    }

    public LocalConnector.LocalResponse call(LocalConnector.LocalRequest request) {
        DefaultLocalResponse localResponse = new DefaultLocalResponse();
        this.execute((Request)new LocalRequestAdapter(request), localResponse);
        return localResponse;
    }

    public void execute(Request request, Response response) {
        try {
            ActionExtractor actionExtractor = new ActionExtractor(request.getPath());
            WebService.Action action = this.getAction(actionExtractor);
            WsUtils.checkFound(action, "Unknown url : %s", request.getPath());
            if (request instanceof ValidatingRequest) {
                ((ValidatingRequest)request).setAction(action);
                ((ValidatingRequest)request).setLocalConnector((LocalConnector)this);
            }
            WebServiceEngine.checkActionExtension(actionExtractor.getExtension());
            RequestVerifier.verifyRequest(action, request);
            action.handler().handle(request, response);
        }
        catch (IllegalArgumentException e) {
            WebServiceEngine.sendErrors(response, 400, Collections.singletonList(e.getMessage()));
        }
        catch (BadRequestException e) {
            WebServiceEngine.sendErrors(response, 400, e.errors());
        }
        catch (ServerException e) {
            WebServiceEngine.sendErrors(response, e.httpCode(), Collections.singletonList(e.getMessage()));
        }
        catch (Exception e) {
            Response.Stream stream = response.stream();
            if (stream instanceof ServletResponse.ServletStream && ((ServletResponse.ServletStream)stream).response().isCommitted()) {
                LOGGER.debug("Request {} has been aborted by client, error is '{}'", (Object)request, (Object)e.getMessage());
                return;
            }
            LOGGER.error("Fail to process request " + request, (Throwable)e);
            WebServiceEngine.sendErrors(response, 500, Collections.singletonList("An error has occurred. Please contact your administrator"));
        }
    }

    @CheckForNull
    private WebService.Action getAction(ActionExtractor actionExtractor) {
        String controllerPath = actionExtractor.getController();
        String actionKey = actionExtractor.getAction();
        WebService.Controller controller = this.context.controller(controllerPath);
        return controller == null ? null : controller.action(actionKey);
    }

    private static void sendErrors(Response response, int status, List<String> errors) {
        Response.Stream stream = response.stream();
        if (stream instanceof ServletResponse.ServletStream) {
            ((ServletResponse.ServletStream)stream).reset();
        }
        stream.setStatus(status);
        stream.setMediaType("application/json");
        try (JsonWriter json = JsonWriter.of((Writer)new OutputStreamWriter(stream.output(), StandardCharsets.UTF_8));){
            json.beginObject();
            WebServiceEngine.writeErrors(json, errors);
            json.endObject();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void writeErrors(JsonWriter json, List<String> errorMessages) {
        if (errorMessages.isEmpty()) {
            return;
        }
        json.name("errors").beginArray();
        errorMessages.forEach(message -> {
            json.beginObject();
            json.prop("msg", message);
            json.endObject();
        });
        json.endArray();
    }

    private static void checkActionExtension(@Nullable String actionExtension) {
        if (Strings.isNullOrEmpty((String)actionExtension)) {
            return;
        }
        Preconditions.checkArgument((ServletRequest.SUPPORTED_MEDIA_TYPES_BY_URL_SUFFIX.get(actionExtension.toLowerCase(Locale.ENGLISH)) != null ? 1 : 0) != 0, (String)"Unknown action extension: %s", (Object[])new Object[]{actionExtension});
    }

    private static class ActionExtractor {
        private static final String SLASH = "/";
        private static final String POINT = ".";
        private final String controller;
        private final String action;
        private final String extension;
        private final String path;

        ActionExtractor(String path) {
            this.path = path;
            String pathWithoutExtension = StringUtils.substringBeforeLast((String)path, (String)POINT);
            this.controller = ActionExtractor.extractController(pathWithoutExtension);
            this.action = StringUtils.substringAfterLast((String)pathWithoutExtension, (String)SLASH);
            Preconditions.checkArgument((!this.action.isEmpty() ? 1 : 0) != 0, (String)"Url is incorrect : '%s'", (Object[])new Object[]{path});
            this.extension = StringUtils.substringAfterLast((String)path, (String)POINT);
        }

        private static String extractController(String path) {
            String controller = StringUtils.substringBeforeLast((String)path, (String)SLASH);
            if (controller.startsWith(SLASH)) {
                return StringUtils.substring((String)controller, (int)1);
            }
            return controller;
        }

        String getController() {
            return this.controller;
        }

        String getAction() {
            return this.action;
        }

        @CheckForNull
        String getExtension() {
            return this.extension;
        }

        String getPath() {
            return this.path;
        }
    }
}

