/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.util;

import okhttp3.OkHttpClient;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.SonarRuntime;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonarqube.ws.client.OkHttpClientBuilder;

@ServerSide
@ComputeEngineSide
public class OkHttpClientProvider
extends ProviderAdapter {
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_MS = 10000;
    private static final int DEFAULT_READ_TIMEOUT_IN_MS = 10000;
    private OkHttpClient okHttpClient;

    public OkHttpClient provide(Configuration config, SonarRuntime runtime) {
        if (this.okHttpClient == null) {
            OkHttpClientBuilder builder = new OkHttpClientBuilder();
            builder.setConnectTimeoutMs(10000L);
            builder.setReadTimeoutMs(10000L);
            builder.setProxyLogin((String)config.get("http.proxyUser").orElse(null));
            builder.setProxyPassword((String)config.get("http.proxyPassword").orElse(null));
            builder.setUserAgent(String.format("SonarQube/%s", runtime.getApiVersion().toString()));
            this.okHttpClient = builder.build();
        }
        return this.okHttpClient;
    }
}

