/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups.ws;

import com.google.common.base.Preconditions;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupDto;
import org.sonar.server.user.UserSession;
import org.sonar.server.usergroups.ws.GroupWsSupport;
import org.sonar.server.usergroups.ws.UserGroupsWsAction;

public class DeleteAction
implements UserGroupsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final GroupWsSupport support;

    public DeleteAction(DbClient dbClient, UserSession userSession, GroupWsSupport support) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.support = support;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("delete").setDescription(String.format("Delete a group. The default groups cannot be deleted.<br/>'%s' or '%s' must be provided.<br />Requires the following permission: 'Administer System'.", "id", "name")).setHandler((RequestHandler)this).setSince("5.2").setPost(true);
        GroupWsSupport.defineGroupWsParameters(action);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            GroupDto group = this.support.findGroupDto(dbSession, request);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, group.getOrganizationUuid());
            this.support.checkGroupIsNotDefault(dbSession, group);
            this.checkNotTryingToDeleteLastAdminGroup(dbSession, group);
            this.removeGroupPermissions(dbSession, group);
            this.removeFromPermissionTemplates(dbSession, group);
            this.removeGroupMembers(dbSession, group);
            this.dbClient.qProfileEditGroupsDao().deleteByGroup(dbSession, group);
            this.dbClient.groupDao().deleteById(dbSession, group.getId().intValue());
            dbSession.commit();
            response.noContent();
        }
    }

    private void checkNotTryingToDeleteLastAdminGroup(DbSession dbSession, GroupDto group) {
        int remaining = this.dbClient.authorizationDao().countUsersWithGlobalPermissionExcludingGroup(dbSession, group.getOrganizationUuid(), OrganizationPermission.ADMINISTER.getKey(), group.getId().intValue());
        Preconditions.checkArgument((remaining > 0 ? 1 : 0) != 0, (Object)"The last system admin group cannot be deleted");
    }

    private void removeGroupPermissions(DbSession dbSession, GroupDto groupId) {
        this.dbClient.roleDao().deleteGroupRolesByGroupId(dbSession, groupId.getId().intValue());
    }

    private void removeFromPermissionTemplates(DbSession dbSession, GroupDto groupId) {
        this.dbClient.permissionTemplateDao().deleteByGroup(dbSession, groupId.getId().intValue());
    }

    private void removeGroupMembers(DbSession dbSession, GroupDto groupId) {
        this.dbClient.userGroupDao().deleteByGroupId(dbSession, groupId.getId().intValue());
    }
}

