/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import java.util.Objects;
import org.sonar.api.server.ServerSide;
import org.sonar.db.DbClient;
import org.sonar.db.user.UserDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.user.ServerUserSession;
import org.sonar.server.user.UserSessionFactory;

@ServerSide
public class UserSessionFactoryImpl
implements UserSessionFactory {
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final OrganizationFlags organizationFlags;

    public UserSessionFactoryImpl(DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider, OrganizationFlags organizationFlags) {
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.organizationFlags = organizationFlags;
    }

    @Override
    public ServerUserSession create(UserDto user) {
        Objects.requireNonNull(user, "UserDto must not be null");
        return new ServerUserSession(this.dbClient, this.organizationFlags, this.defaultOrganizationProvider, user);
    }

    @Override
    public ServerUserSession createAnonymous() {
        return new ServerUserSession(this.dbClient, this.organizationFlags, this.defaultOrganizationProvider, null);
    }
}

