/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.test.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.server.es.BaseDoc;
import org.sonar.server.test.index.CoveredFileDoc;

public class TestDoc
extends BaseDoc {
    public TestDoc(Map<String, Object> fields) {
        super(fields);
    }

    @VisibleForTesting
    public TestDoc() {
        super(Maps.newHashMapWithExpectedSize((int)10));
    }

    @Override
    public String getId() {
        return this.testUuid();
    }

    @Override
    public String getRouting() {
        return this.projectUuid();
    }

    @Override
    public String getParent() {
        return null;
    }

    public String projectUuid() {
        return (String)this.getField("projectUuid");
    }

    public TestDoc setProjectUuid(String projectUuid) {
        this.setField("projectUuid", projectUuid);
        return this;
    }

    public String fileUuid() {
        return (String)this.getField("fileUuid");
    }

    public TestDoc setFileUuid(String fileUuid) {
        this.setField("fileUuid", fileUuid);
        return this;
    }

    public String testUuid() {
        return (String)this.getField("testUuid");
    }

    public TestDoc setUuid(String testUuid) {
        this.setField("testUuid", testUuid);
        return this;
    }

    public String name() {
        return (String)this.getField("name");
    }

    public TestDoc setName(String name) {
        this.setField("name", name);
        return this;
    }

    public String status() {
        return (String)this.getField("status");
    }

    public TestDoc setStatus(String status) {
        this.setField("status", status);
        return this;
    }

    @CheckForNull
    public String message() {
        return (String)this.getNullableField("message");
    }

    public TestDoc setMessage(String message) {
        this.setField("message", message);
        return this;
    }

    @CheckForNull
    public String stackTrace() {
        return (String)this.getNullableField("stacktrace");
    }

    public TestDoc setStackTrace(String stackTrace) {
        this.setField("stacktrace", stackTrace);
        return this;
    }

    @CheckForNull
    public Long durationInMs() {
        Number number = (Number)this.getNullableField("durationInMs");
        return number == null ? null : Long.valueOf(number.longValue());
    }

    public TestDoc setDurationInMs(Long durationInMs) {
        this.setField("durationInMs", durationInMs);
        return this;
    }

    public List<CoveredFileDoc> coveredFiles() {
        List coveredFilesAsMaps = (List)this.getNullableField("coveredFiles");
        if (coveredFilesAsMaps == null) {
            return new ArrayList<CoveredFileDoc>();
        }
        ArrayList<CoveredFileDoc> coveredFiles = new ArrayList<CoveredFileDoc>();
        for (Map coveredFileMap : coveredFilesAsMaps) {
            coveredFiles.add(new CoveredFileDoc(coveredFileMap));
        }
        return coveredFiles;
    }

    public TestDoc setCoveredFiles(List<CoveredFileDoc> coveredFiles) {
        ArrayList<Map<String, Object>> coveredFilesAsMaps = new ArrayList<Map<String, Object>>();
        for (CoveredFileDoc coveredFile : coveredFiles) {
            coveredFilesAsMaps.add(coveredFile.getFields());
        }
        this.setField("coveredFiles", coveredFilesAsMaps);
        return this;
    }
}

