/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.telemetry;

import java.io.IOException;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@ServerSide
public class TelemetryClient {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Logger LOG = Loggers.get(TelemetryClient.class);
    private final OkHttpClient okHttpClient;
    private final Configuration config;

    public TelemetryClient(OkHttpClient okHttpClient, Configuration config) {
        this.okHttpClient = okHttpClient;
        this.config = config;
    }

    void upload(String json) throws IOException {
        Request request = this.buildHttpRequest(json);
        TelemetryClient.execute(this.okHttpClient.newCall(request));
    }

    void optOut(String json) {
        Request.Builder request = new Request.Builder();
        request.url(this.serverUrl());
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        request.delete(body);
        try {
            TelemetryClient.execute(this.okHttpClient.newCall(request.build()));
        }
        catch (IOException e) {
            LOG.debug("Error when sending opt-out usage statistics: {}", (Object)e.getMessage());
        }
    }

    private Request buildHttpRequest(String json) {
        Request.Builder request = new Request.Builder();
        request.url(this.serverUrl());
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        request.post(body);
        return request.build();
    }

    private String serverUrl() {
        return (String)this.config.get("sonar.telemetry.url").orElseThrow(() -> new IllegalStateException(String.format("Setting '%s' must be provided.", "sonar.telemetry.url")));
    }

    private static void execute(Call call) throws IOException {
        Response ignored = call.execute();
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignored.close();
            }
        }
    }
}

