/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.sonar.api.resources.Languages;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.db.rule.RuleRepositoryDto;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.RuleActivator;
import org.sonar.server.qualityprofile.index.ActiveRuleIndexer;
import org.sonar.server.rule.RuleDefinitionsLoader;
import org.sonar.server.rule.WebServerRuleFinder;
import org.sonar.server.rule.index.RuleIndexer;

public class RegisterRules
implements Startable {
    private static final Logger LOG = Loggers.get(RegisterRules.class);
    private final RuleDefinitionsLoader defLoader;
    private final RuleActivator ruleActivator;
    private final DbClient dbClient;
    private final RuleIndexer ruleIndexer;
    private final ActiveRuleIndexer activeRuleIndexer;
    private final Languages languages;
    private final System2 system2;
    private final OrganizationFlags organizationFlags;
    private final WebServerRuleFinder webServerRuleFinder;

    public RegisterRules(RuleDefinitionsLoader defLoader, RuleActivator ruleActivator, DbClient dbClient, RuleIndexer ruleIndexer, ActiveRuleIndexer activeRuleIndexer, Languages languages, System2 system2, OrganizationFlags organizationFlags, WebServerRuleFinder webServerRuleFinder) {
        this.defLoader = defLoader;
        this.ruleActivator = ruleActivator;
        this.dbClient = dbClient;
        this.ruleIndexer = ruleIndexer;
        this.activeRuleIndexer = activeRuleIndexer;
        this.languages = languages;
        this.system2 = system2;
        this.organizationFlags = organizationFlags;
        this.webServerRuleFinder = webServerRuleFinder;
    }

    public void start() {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Register rules");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Map<RuleKey, RuleDefinitionDto> allRules = this.loadRules(dbSession);
            ArrayList<RuleKey> keysToIndex = new ArrayList<RuleKey>();
            RulesDefinition.Context context = this.defLoader.load();
            boolean orgsEnabled = this.organizationFlags.isEnabled(dbSession);
            for (RulesDefinition.ExtendedRepository repoDef : this.getRepositories(context)) {
                if (this.languages.get(repoDef.language()) == null) continue;
                for (RulesDefinition.Rule ruleDef : repoDef.rules()) {
                    RuleKey ruleKey = RuleKey.of((String)ruleDef.repository().key(), (String)ruleDef.key());
                    if (ruleDef.template() && orgsEnabled) {
                        RuleDefinitionDto ruleDefinition = allRules.get(ruleKey);
                        if (ruleDefinition != null && ruleDefinition.getStatus() == RuleStatus.REMOVED) {
                            LOG.debug("Template rule {} kept removed, because organizations are enabled.", (Object)ruleKey);
                            allRules.remove(ruleKey);
                            continue;
                        }
                        LOG.info("Template rule {} will not be imported, because organizations are enabled.", (Object)ruleKey);
                        continue;
                    }
                    boolean relevantForIndex = this.registerRule(ruleDef, allRules, dbSession);
                    if (!relevantForIndex) continue;
                    keysToIndex.add(ruleKey);
                }
                dbSession.commit();
            }
            List<RuleDefinitionDto> removedRules = this.processRemainingDbRules(allRules.values(), dbSession);
            List<ActiveRuleChange> changes = this.removeActiveRulesOnStillExistingRepositories(dbSession, removedRules, context);
            dbSession.commit();
            keysToIndex.addAll(removedRules.stream().map(RuleDefinitionDto::getKey).collect(Collectors.toList()));
            this.persistRepositories(dbSession, context.repositories());
            this.ruleIndexer.commitAndIndex(dbSession, keysToIndex);
            this.activeRuleIndexer.commitAndIndex(dbSession, changes);
            profiler.stopDebug();
            this.webServerRuleFinder.startCaching();
        }
    }

    private void persistRepositories(DbSession dbSession, List<RulesDefinition.Repository> repositories) {
        this.dbClient.ruleRepositoryDao().truncate(dbSession);
        List dtos = (List)repositories.stream().map(r -> new RuleRepositoryDto(r.key(), r.language(), r.name())).collect(MoreCollectors.toList((int)repositories.size()));
        this.dbClient.ruleRepositoryDao().insert(dbSession, (Collection)dtos);
        dbSession.commit();
    }

    public void stop() {
    }

    private boolean registerRule(RulesDefinition.Rule ruleDef, Map<RuleKey, RuleDefinitionDto> allRules, DbSession session) {
        boolean newRule;
        RuleDefinitionDto rule;
        RuleKey ruleKey = RuleKey.of((String)ruleDef.repository().key(), (String)ruleDef.key());
        RuleDefinitionDto existingRule = allRules.remove(ruleKey);
        if (existingRule == null) {
            rule = this.createRuleDto(ruleDef, session);
            newRule = true;
        } else {
            rule = existingRule;
            newRule = false;
        }
        boolean executeUpdate = false;
        if (this.mergeRule(ruleDef, rule)) {
            executeUpdate = true;
        }
        if (this.mergeDebtDefinitions(ruleDef, rule)) {
            executeUpdate = true;
        }
        if (RegisterRules.mergeTags(ruleDef, rule)) {
            executeUpdate = true;
        }
        if (executeUpdate) {
            this.update(session, rule);
        }
        this.mergeParams(ruleDef, rule, session);
        return newRule || executeUpdate;
    }

    private Map<RuleKey, RuleDefinitionDto> loadRules(DbSession session) {
        HashMap<RuleKey, RuleDefinitionDto> rules = new HashMap<RuleKey, RuleDefinitionDto>();
        for (RuleDefinitionDto rule : this.dbClient.ruleDao().selectAllDefinitions(session)) {
            rules.put(rule.getKey(), rule);
        }
        return rules;
    }

    private List<RulesDefinition.ExtendedRepository> getRepositories(RulesDefinition.Context context) {
        ArrayList<RulesDefinition.ExtendedRepository> repositories = new ArrayList<RulesDefinition.ExtendedRepository>();
        for (RulesDefinition.Repository repoDef : context.repositories()) {
            repositories.add((RulesDefinition.ExtendedRepository)repoDef);
        }
        for (RulesDefinition.ExtendedRepository extendedRepoDef : context.extendedRepositories()) {
            if (context.repository(extendedRepoDef.key()) == null) {
                LOG.warn(String.format("Extension is ignored, repository %s does not exist", extendedRepoDef.key()));
                continue;
            }
            repositories.add(extendedRepoDef);
        }
        return repositories;
    }

    private RuleDefinitionDto createRuleDto(RulesDefinition.Rule ruleDef, DbSession session) {
        RuleDefinitionDto ruleDto = new RuleDefinitionDto().setRuleKey(RuleKey.of((String)ruleDef.repository().key(), (String)ruleDef.key())).setPluginKey(ruleDef.pluginKey()).setIsTemplate(ruleDef.template()).setConfigKey(ruleDef.internalKey()).setLanguage(ruleDef.repository().language()).setName(ruleDef.name()).setSeverity(ruleDef.severity()).setStatus(ruleDef.status()).setGapDescription(ruleDef.gapDescription()).setSystemTags(ruleDef.tags()).setType(RuleType.valueOf((String)ruleDef.type().name())).setCreatedAt(this.system2.now()).setUpdatedAt(this.system2.now());
        if (ruleDef.htmlDescription() != null) {
            ruleDto.setDescription(ruleDef.htmlDescription());
            ruleDto.setDescriptionFormat(RuleDto.Format.HTML);
        } else {
            ruleDto.setDescription(ruleDef.markdownDescription());
            ruleDto.setDescriptionFormat(RuleDto.Format.MARKDOWN);
        }
        this.dbClient.ruleDao().insert(session, ruleDto);
        return ruleDto;
    }

    private boolean mergeRule(RulesDefinition.Rule def, RuleDefinitionDto dto) {
        boolean isTemplate;
        boolean changed = false;
        if (!StringUtils.equals((String)dto.getName(), (String)def.name())) {
            dto.setName(def.name());
            changed = true;
        }
        if (this.mergeDescription(def, dto)) {
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getPluginKey(), (String)def.pluginKey())) {
            dto.setPluginKey(def.pluginKey());
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getConfigKey(), (String)def.internalKey())) {
            dto.setConfigKey(def.internalKey());
            changed = true;
        }
        String severity = def.severity();
        if (!ObjectUtils.equals((Object)dto.getSeverityString(), (Object)severity)) {
            dto.setSeverity(severity);
            changed = true;
        }
        if ((isTemplate = def.template()) != dto.isTemplate()) {
            dto.setIsTemplate(isTemplate);
            changed = true;
        }
        if (def.status() != dto.getStatus()) {
            dto.setStatus(def.status());
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getLanguage(), (String)def.repository().language())) {
            dto.setLanguage(def.repository().language());
            changed = true;
        }
        RuleType type = RuleType.valueOf((String)def.type().name());
        if (!ObjectUtils.equals((Object)dto.getType(), (Object)type.getDbConstant())) {
            dto.setType(type);
            changed = true;
        }
        return changed;
    }

    private boolean mergeDescription(RulesDefinition.Rule def, RuleDefinitionDto dto) {
        boolean changed = false;
        if (def.htmlDescription() != null && !StringUtils.equals((String)dto.getDescription(), (String)def.htmlDescription())) {
            dto.setDescription(def.htmlDescription());
            dto.setDescriptionFormat(RuleDto.Format.HTML);
            changed = true;
        } else if (def.markdownDescription() != null && !StringUtils.equals((String)dto.getDescription(), (String)def.markdownDescription())) {
            dto.setDescription(def.markdownDescription());
            dto.setDescriptionFormat(RuleDto.Format.MARKDOWN);
            changed = true;
        }
        return changed;
    }

    private boolean mergeDebtDefinitions(RulesDefinition.Rule def, RuleDefinitionDto dto) {
        boolean hasDebt;
        DebtRemediationFunction debtRemediationFunction = def.debtRemediationFunction();
        boolean bl = hasDebt = debtRemediationFunction != null;
        if (hasDebt) {
            return this.mergeDebtDefinitions(dto, debtRemediationFunction.type().name(), debtRemediationFunction.gapMultiplier(), debtRemediationFunction.baseEffort(), def.gapDescription());
        }
        return this.mergeDebtDefinitions(dto, null, null, null, null);
    }

    private boolean mergeDebtDefinitions(RuleDefinitionDto dto, @Nullable String remediationFunction, @Nullable String remediationCoefficient, @Nullable String remediationOffset, @Nullable String effortToFixDescription) {
        boolean changed = false;
        if (!StringUtils.equals((String)dto.getDefRemediationFunction(), (String)remediationFunction)) {
            dto.setDefRemediationFunction(remediationFunction);
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getDefRemediationGapMultiplier(), (String)remediationCoefficient)) {
            dto.setDefRemediationGapMultiplier(remediationCoefficient);
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getDefRemediationBaseEffort(), (String)remediationOffset)) {
            dto.setDefRemediationBaseEffort(remediationOffset);
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getGapDescription(), (String)effortToFixDescription)) {
            dto.setGapDescription(effortToFixDescription);
            changed = true;
        }
        return changed;
    }

    private void mergeParams(RulesDefinition.Rule ruleDef, RuleDefinitionDto rule, DbSession session) {
        List paramDtos = this.dbClient.ruleDao().selectRuleParamsByRuleKey(session, rule.getKey());
        HashMap existingParamsByName = Maps.newHashMap();
        Profiler profiler = Profiler.create((Logger)Loggers.get(this.getClass()));
        for (RuleParamDto paramDto : paramDtos) {
            RulesDefinition.Param paramDef = ruleDef.param(paramDto.getName());
            if (paramDef == null) {
                profiler.start();
                this.dbClient.activeRuleDao().deleteParamsByRuleParamOfAllOrganizations(session, paramDto);
                profiler.stopDebug(String.format("Propagate deleted param with name %s to active rules of rule %s", paramDto.getName(), rule.getKey()));
                this.dbClient.ruleDao().deleteRuleParam(session, paramDto.getId().intValue());
                continue;
            }
            if (this.mergeParam(paramDto, paramDef)) {
                this.dbClient.ruleDao().updateRuleParam(session, rule, paramDto);
            }
            existingParamsByName.put(paramDto.getName(), paramDto);
        }
        for (RulesDefinition.Param param : ruleDef.params()) {
            RuleParamDto paramDto = (RuleParamDto)existingParamsByName.get(param.key());
            if (paramDto != null) continue;
            paramDto = RuleParamDto.createFor((RuleDefinitionDto)rule).setName(param.key()).setDescription(param.description()).setDefaultValue(param.defaultValue()).setType(param.type().toString());
            this.dbClient.ruleDao().insertRuleParam(session, rule, paramDto);
            if (StringUtils.isEmpty((String)param.defaultValue())) continue;
            profiler.start();
            for (ActiveRuleDto activeRule : this.dbClient.activeRuleDao().selectByRuleIdOfAllOrganizations(session, rule.getId().intValue())) {
                ActiveRuleParamDto activeParam = ActiveRuleParamDto.createFor((RuleParamDto)paramDto).setValue(param.defaultValue());
                this.dbClient.activeRuleDao().insertParam(session, activeRule, activeParam);
            }
            profiler.stopDebug(String.format("Propagate new param with name %s to active rules of rule %s", paramDto.getName(), rule.getKey()));
        }
    }

    private boolean mergeParam(RuleParamDto paramDto, RulesDefinition.Param paramDef) {
        boolean changed = false;
        if (!StringUtils.equals((String)paramDto.getType(), (String)paramDef.type().toString())) {
            paramDto.setType(paramDef.type().toString());
            changed = true;
        }
        if (!StringUtils.equals((String)paramDto.getDefaultValue(), (String)paramDef.defaultValue())) {
            paramDto.setDefaultValue(paramDef.defaultValue());
            changed = true;
        }
        if (!StringUtils.equals((String)paramDto.getDescription(), (String)paramDef.description())) {
            paramDto.setDescription(paramDef.description());
            changed = true;
        }
        return changed;
    }

    private static boolean mergeTags(RulesDefinition.Rule ruleDef, RuleDefinitionDto dto) {
        boolean changed = false;
        if (RuleStatus.REMOVED == ruleDef.status()) {
            dto.setSystemTags(Collections.emptySet());
            changed = true;
        } else if (dto.getSystemTags().size() != ruleDef.tags().size() || !dto.getSystemTags().containsAll(ruleDef.tags())) {
            dto.setSystemTags(ruleDef.tags());
            changed = true;
        }
        return changed;
    }

    private List<RuleDefinitionDto> processRemainingDbRules(Collection<RuleDefinitionDto> existingRules, DbSession session) {
        ArrayList customRules = Lists.newArrayList();
        ArrayList removedRules = Lists.newArrayList();
        for (RuleDefinitionDto rule : existingRules) {
            if (rule.isCustomRule()) {
                customRules.add(rule);
                continue;
            }
            if (rule.getStatus() == RuleStatus.REMOVED) continue;
            this.removeRule(session, removedRules, rule);
        }
        for (RuleDefinitionDto customRule : customRules) {
            Integer templateId = customRule.getTemplateId();
            Preconditions.checkNotNull((Object)templateId, (String)"Template id of the custom rule '%s' is null", (Object[])new Object[]{customRule});
            Optional template = this.dbClient.ruleDao().selectDefinitionById((long)templateId.intValue(), session);
            if (template.isPresent() && ((RuleDefinitionDto)template.get()).getStatus() != RuleStatus.REMOVED) {
                if (!RegisterRules.updateCustomRuleFromTemplateRule(customRule, (RuleDefinitionDto)template.get())) continue;
                this.update(session, customRule);
                continue;
            }
            this.removeRule(session, removedRules, customRule);
        }
        session.commit();
        return removedRules;
    }

    private void removeRule(DbSession session, List<RuleDefinitionDto> removedRules, RuleDefinitionDto rule) {
        LOG.info(String.format("Disable rule %s", rule.getKey()));
        rule.setStatus(RuleStatus.REMOVED);
        rule.setSystemTags(Collections.emptySet());
        this.update(session, rule);
        removedRules.add(rule);
        if (removedRules.size() % 100 == 0) {
            session.commit();
        }
    }

    private static boolean updateCustomRuleFromTemplateRule(RuleDefinitionDto customRule, RuleDefinitionDto templateRule) {
        boolean changed = false;
        if (!StringUtils.equals((String)customRule.getLanguage(), (String)templateRule.getLanguage())) {
            customRule.setLanguage(templateRule.getLanguage());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getConfigKey(), (String)templateRule.getConfigKey())) {
            customRule.setConfigKey(templateRule.getConfigKey());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getPluginKey(), (String)templateRule.getPluginKey())) {
            customRule.setPluginKey(templateRule.getPluginKey());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getDefRemediationFunction(), (String)templateRule.getDefRemediationFunction())) {
            customRule.setDefRemediationFunction(templateRule.getDefRemediationFunction());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getDefRemediationGapMultiplier(), (String)templateRule.getDefRemediationGapMultiplier())) {
            customRule.setDefRemediationGapMultiplier(templateRule.getDefRemediationGapMultiplier());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getDefRemediationBaseEffort(), (String)templateRule.getDefRemediationBaseEffort())) {
            customRule.setDefRemediationBaseEffort(templateRule.getDefRemediationBaseEffort());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getGapDescription(), (String)templateRule.getGapDescription())) {
            customRule.setGapDescription(templateRule.getGapDescription());
            changed = true;
        }
        if (customRule.getStatus() != templateRule.getStatus()) {
            customRule.setStatus(templateRule.getStatus());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getSeverityString(), (String)templateRule.getSeverityString())) {
            customRule.setSeverity(templateRule.getSeverityString());
            changed = true;
        }
        return changed;
    }

    private List<ActiveRuleChange> removeActiveRulesOnStillExistingRepositories(DbSession session, Collection<RuleDefinitionDto> removedRules, RulesDefinition.Context context) {
        ArrayList repositoryKeys = Lists.newArrayList((Iterable)Iterables.transform((Iterable)context.repositories(), RulesDefinition.ExtendedRepository::key));
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        Profiler profiler = Profiler.create((Logger)Loggers.get(this.getClass()));
        for (RuleDefinitionDto rule : removedRules) {
            if (!repositoryKeys.contains(rule.getRepositoryKey())) continue;
            profiler.start();
            changes.addAll(this.ruleActivator.delete(session, rule));
            profiler.stopDebug(String.format("Remove active rule for rule %s", rule.getKey()));
        }
        return changes;
    }

    private void update(DbSession session, RuleDefinitionDto rule) {
        rule.setUpdatedAt(this.system2.now());
        this.dbClient.ruleDao().update(session, rule);
    }
}

