/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.server.rule.CommonRuleDefinitions;
import org.sonar.server.rule.CommonRuleKeys;

public class CommonRuleDefinitionsImpl
implements CommonRuleDefinitions {
    private final Languages languages;

    public CommonRuleDefinitionsImpl(Languages languages) {
        this.languages = languages;
    }

    @Override
    public void define(RulesDefinition.Context context) {
        for (Language language : this.languages.all()) {
            RulesDefinition.NewRepository repo = context.createRepository(CommonRuleKeys.commonRepositoryForLang(language.getKey()), language.getKey());
            repo.setName("Common " + language.getName());
            CommonRuleDefinitionsImpl.defineBranchCoverageRule(repo);
            CommonRuleDefinitionsImpl.defineLineCoverageRule(repo);
            CommonRuleDefinitionsImpl.defineCommentDensityRule(repo);
            CommonRuleDefinitionsImpl.defineDuplicatedBlocksRule(repo);
            CommonRuleDefinitionsImpl.defineFailedUnitTestRule(repo);
            CommonRuleDefinitionsImpl.defineSkippedUnitTestRule(repo);
            repo.done();
        }
    }

    private static void defineBranchCoverageRule(RulesDefinition.NewRepository repo) {
        RulesDefinition.NewRule rule = repo.createRule("InsufficientBranchCoverage");
        rule.setName("Branches should have sufficient coverage by tests").addTags(new String[]{"bad-practice"}).setHtmlDescription("An issue is created on a file as soon as the branch coverage on this file is less than the required threshold.It gives the number of branches to be covered in order to reach the required threshold.").setDebtRemediationFunction(rule.debtRemediationFunctions().linear("5min")).setGapDescription("number of uncovered conditions").setSeverity("MAJOR");
        rule.createParam("minimumBranchCoverageRatio").setName("The minimum required branch coverage ratio").setDefaultValue("65").setType(RuleParamType.FLOAT);
    }

    private static void defineLineCoverageRule(RulesDefinition.NewRepository repo) {
        RulesDefinition.NewRule rule = repo.createRule("InsufficientLineCoverage");
        rule.setName("Lines should have sufficient coverage by tests").addTags(new String[]{"bad-practice"}).setHtmlDescription("An issue is created on a file as soon as the line coverage on this file is less than the required threshold. It gives the number of lines to be covered in order to reach the required threshold.").setDebtRemediationFunction(rule.debtRemediationFunctions().linear("2min")).setGapDescription("number of lines under the coverage threshold").setSeverity("MAJOR");
        rule.createParam("minimumLineCoverageRatio").setName("The minimum required line coverage ratio").setDefaultValue("65").setType(RuleParamType.FLOAT);
    }

    private static void defineCommentDensityRule(RulesDefinition.NewRepository repo) {
        RulesDefinition.NewRule rule = repo.createRule("InsufficientCommentDensity");
        rule.setName("Source files should have a sufficient density of comment lines").addTags(new String[]{"convention"}).setHtmlDescription("An issue is created on a file as soon as the density of comment lines on this file is less than the required threshold. The number of comment lines to be written in order to reach the required threshold is provided by each issue message.").setDebtRemediationFunction(rule.debtRemediationFunctions().linear("2min")).setGapDescription("number of lines required to meet minimum density").setSeverity("MAJOR");
        rule.createParam("minimumCommentDensity").setName("The minimum required comment density").setDefaultValue("25").setType(RuleParamType.FLOAT);
    }

    private static void defineDuplicatedBlocksRule(RulesDefinition.NewRepository repo) {
        RulesDefinition.NewRule rule = repo.createRule("DuplicatedBlocks");
        rule.setName("Source files should not have any duplicated blocks").addTags(new String[]{"pitfall"}).setHtmlDescription("An issue is created on a file as soon as there is at least one block of duplicated code on this file").setDebtRemediationFunction(rule.debtRemediationFunctions().linearWithOffset("10min", "10min")).setGapDescription("number of duplicate blocks").setSeverity("MAJOR");
    }

    private static void defineFailedUnitTestRule(RulesDefinition.NewRepository repo) {
        RulesDefinition.NewRule rule = repo.createRule("FailedUnitTests");
        rule.setName("Failed unit tests should be fixed").addTags(new String[]{"bug"}).setHtmlDescription("Test failures or errors generally indicate that regressions have been introduced. Those tests should be handled as soon as possible to reduce the cost to fix the corresponding regressions.").setDebtRemediationFunction(rule.debtRemediationFunctions().linear("10min")).setGapDescription("number of failed tests").setSeverity("MAJOR");
    }

    private static void defineSkippedUnitTestRule(RulesDefinition.NewRepository repo) {
        RulesDefinition.NewRule rule = repo.createRule("SkippedUnitTests");
        rule.setName("Skipped unit tests should be either removed or fixed").addTags(new String[]{"pitfall"}).setHtmlDescription("Skipped unit tests are considered as dead code. Either they should be activated again (and updated) or they should be removed.").setDebtRemediationFunction(rule.debtRemediationFunctions().linear("10min")).setGapDescription("number of skipped tests").setSeverity("MAJOR");
    }
}

