/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualityprofile.DefaultQProfileDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.user.UserSession;

public class SetDefaultAction
implements QProfileWsAction {
    private final Languages languages;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final QProfileWsSupport qProfileWsSupport;

    public SetDefaultAction(Languages languages, DbClient dbClient, UserSession userSession, QProfileWsSupport qProfileWsSupport) {
        this.languages = languages;
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.qProfileWsSupport = qProfileWsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction setDefault = controller.createAction("set_default").setSince("5.2").setDescription("Select the default profile for a given language.<br> Requires to be logged in and the 'Administer Quality Profiles' permission.").setPost(true).setHandler((RequestHandler)this);
        QProfileWsSupport.createOrganizationParam(setDefault).setSince("6.4");
        QProfileReference.defineParams(setDefault, this.languages);
    }

    public void handle(Request request, Response response) {
        this.userSession.checkLoggedIn();
        QProfileReference reference = QProfileReference.from(request);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QProfileDto qualityProfile = this.qProfileWsSupport.getProfile(dbSession, reference);
            this.dbClient.organizationDao().selectByUuid(dbSession, qualityProfile.getOrganizationUuid()).orElseThrow(() -> new IllegalStateException(String.format("Cannot find organization '%s' for quality profile '%s'", qualityProfile.getOrganizationUuid(), qualityProfile.getKee())));
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, qualityProfile.getOrganizationUuid());
            this.setDefault(dbSession, qualityProfile);
            dbSession.commit();
        }
        response.noContent();
    }

    public void setDefault(DbSession dbSession, QProfileDto profile) {
        this.dbClient.defaultQProfileDao().insertOrUpdate(dbSession, DefaultQProfileDto.from((QProfileDto)profile));
    }
}

