/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.protobuf.Message;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.QProfileCopier;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.QualityProfiles;

public class CopyAction
implements QProfileWsAction {
    private static final String PARAM_TO_NAME = "toName";
    private static final String PARAM_FROM_KEY = "fromKey";
    private final DbClient dbClient;
    private final QProfileCopier profileCopier;
    private final Languages languages;
    private final UserSession userSession;
    private final QProfileWsSupport wsSupport;

    public CopyAction(DbClient dbClient, QProfileCopier profileCopier, Languages languages, UserSession userSession, QProfileWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.profileCopier = profileCopier;
        this.languages = languages;
        this.userSession = userSession;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("copy").setSince("5.2").setDescription("Copy a quality profile.<br> Requires to be logged in and the 'Administer Quality Profiles' permission.").setPost(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_TO_NAME).setDescription("Name for the new quality profile.").setExampleValue((Object)"My Sonar way").setRequired(true);
        action.createParam(PARAM_FROM_KEY).setDescription("Quality profile key").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy").setRequired(true);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String newName = request.mandatoryParam(PARAM_TO_NAME);
        String profileKey = request.mandatoryParam(PARAM_FROM_KEY);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QProfileDto sourceProfile = this.wsSupport.getProfile(dbSession, QProfileReference.fromKey(profileKey));
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, sourceProfile.getOrganizationUuid());
            QProfileDto copiedProfile = this.profileCopier.copyToName(dbSession, sourceProfile, newName);
            boolean isDefault = this.dbClient.defaultQProfileDao().isDefault(dbSession, copiedProfile.getOrganizationUuid(), copiedProfile.getKee());
            QualityProfiles.CopyWsResponse wsResponse = this.buildResponse(copiedProfile, isDefault);
            WsUtils.writeProtobuf((Message)wsResponse, request, response);
        }
    }

    private QualityProfiles.CopyWsResponse buildResponse(QProfileDto copiedProfile, boolean isDefault) {
        String languageKey = copiedProfile.getLanguage();
        Language language = this.languages.get(copiedProfile.getLanguage());
        String parentKey = copiedProfile.getParentKee();
        QualityProfiles.CopyWsResponse.Builder wsResponse = QualityProfiles.CopyWsResponse.newBuilder();
        wsResponse.setKey(copiedProfile.getKee());
        wsResponse.setName(copiedProfile.getName());
        wsResponse.setLanguage(languageKey);
        Protobuf.setNullable((Object)language, l -> wsResponse.setLanguageName(l.getName()));
        wsResponse.setIsDefault(isDefault);
        wsResponse.setIsInherited(parentKey != null);
        Protobuf.setNullable((Object)parentKey, arg_0 -> ((QualityProfiles.CopyWsResponse.Builder)wsResponse).setParentKey(arg_0));
        return wsResponse.build();
    }
}

