/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import java.util.Arrays;
import java.util.Collection;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.UuidFactory;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.QProfileEditGroupsDto;
import org.sonar.db.user.GroupDto;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;

public class AddGroupAction
implements QProfileWsAction {
    private final DbClient dbClient;
    private final UuidFactory uuidFactory;
    private final QProfileWsSupport wsSupport;
    private final Languages languages;

    public AddGroupAction(DbClient dbClient, UuidFactory uuidFactory, QProfileWsSupport wsSupport, Languages languages) {
        this.dbClient = dbClient;
        this.uuidFactory = uuidFactory;
        this.wsSupport = wsSupport;
        this.languages = languages;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add_group").setDescription("Allow a group to edit a Quality Profile.<br>Requires one of the following permissions:<ul>  <li>'Administer Quality Profiles'</li>  <li>Edit right on the specified quality profile</li></ul>").setHandler((RequestHandler)this).setPost(true).setInternal(true).setSince("6.6");
        action.createParam("qualityProfile").setDescription("Quality Profile name").setRequired(true).setExampleValue((Object)"Recommended quality profile");
        action.createParam("language").setDescription("Quality profile language").setRequired(true).setPossibleValues((Collection)Arrays.stream(this.languages.all()).map(Language::getKey).collect(MoreCollectors.toSet()));
        action.createParam("group").setDescription("Group name").setRequired(true).setExampleValue((Object)"sonar-administrators");
        QProfileWsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganizationByKey(dbSession, request.param("organization"));
            QProfileDto profile = this.wsSupport.getProfile(dbSession, organization, request.mandatoryParam("qualityProfile"), request.mandatoryParam("language"));
            this.wsSupport.checkCanEdit(dbSession, organization, profile);
            GroupDto user = this.wsSupport.getGroup(dbSession, organization, request.mandatoryParam("group"));
            this.addGroup(dbSession, profile, user);
        }
        response.noContent();
    }

    private void addGroup(DbSession dbSession, QProfileDto profile, GroupDto group) {
        if (this.dbClient.qProfileEditGroupsDao().exists(dbSession, profile, group)) {
            return;
        }
        this.dbClient.qProfileEditGroupsDao().insert(dbSession, new QProfileEditGroupsDto().setUuid(this.uuidFactory.create()).setGroupId(group.getId().intValue()).setQProfileUuid(profile.getKee()));
        dbSession.commit();
    }
}

