/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleKey;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.server.qualityprofile.ActiveRule;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.RuleActivation;
import org.sonar.server.ws.WsUtils;

class RuleActivatorContext {
    private final QProfileDto profile;
    private final RulesProfileDto rulesProfile;
    private final Date initDate = new Date();
    private RuleDefinitionDto rule;
    private final Map<String, RuleParamDto> ruleParams = new HashMap<String, RuleParamDto>();
    private ActiveRuleDto activeRule;
    private ActiveRuleDto parentActiveRule;
    private final Map<String, ActiveRuleParamDto> activeRuleParams = new HashMap<String, ActiveRuleParamDto>();
    private final Map<String, ActiveRuleParamDto> parentActiveRuleParams = new HashMap<String, ActiveRuleParamDto>();
    private final boolean isCascade;

    RuleActivatorContext(QProfileDto profile, boolean isCascade) {
        this.profile = profile;
        this.rulesProfile = RulesProfileDto.from((QProfileDto)profile);
        this.isCascade = isCascade;
    }

    RuleActivatorContext(RulesProfileDto rulesProfile) {
        Preconditions.checkArgument((boolean)rulesProfile.isBuiltIn(), (Object)("Rules profile must be a built-in profile: " + rulesProfile.getKee()));
        this.profile = null;
        this.rulesProfile = rulesProfile;
        this.isCascade = false;
    }

    @CheckForNull
    QProfileDto getProfile() {
        return this.profile;
    }

    RulesProfileDto getRulesProfile() {
        return this.rulesProfile;
    }

    boolean isBuiltIn() {
        return this.profile == null;
    }

    boolean isCascade() {
        return this.isCascade;
    }

    ActiveRuleKey activeRuleKey() {
        return ActiveRuleKey.of((RulesProfileDto)this.rulesProfile, (RuleKey)this.rule.getKey());
    }

    RuleDefinitionDto getRule() {
        return this.rule;
    }

    RuleActivatorContext setRule(RuleDefinitionDto rule) {
        this.rule = rule;
        return this;
    }

    Date getInitDate() {
        return this.initDate;
    }

    Map<String, RuleParamDto> ruleParamsByKeys() {
        return this.ruleParams;
    }

    Collection<RuleParamDto> ruleParams() {
        return this.ruleParams.values();
    }

    RuleActivatorContext setRuleParams(Collection<RuleParamDto> ruleParams) {
        this.ruleParams.clear();
        for (RuleParamDto ruleParam : ruleParams) {
            this.ruleParams.put(ruleParam.getName(), ruleParam);
        }
        return this;
    }

    @CheckForNull
    ActiveRuleDto activeRule() {
        return this.activeRule;
    }

    RuleActivatorContext setActiveRule(@Nullable ActiveRuleDto a) {
        this.activeRule = a;
        return this;
    }

    @CheckForNull
    ActiveRuleDto parentActiveRule() {
        return this.parentActiveRule;
    }

    RuleActivatorContext setParentActiveRule(@Nullable ActiveRuleDto a) {
        this.parentActiveRule = a;
        return this;
    }

    @CheckForNull
    String requestParamValue(RuleActivation request, String key) {
        if (this.rule.isCustomRule()) {
            return null;
        }
        return request.getParameter(key);
    }

    boolean hasRequestParamValue(RuleActivation request, String key) {
        return request.hasParameter(key);
    }

    @CheckForNull
    String currentParamValue(String key) {
        ActiveRuleParamDto param = this.activeRuleParams.get(key);
        return param != null ? param.getValue() : null;
    }

    @CheckForNull
    String parentParamValue(String key) {
        ActiveRuleParamDto param = this.parentActiveRuleParams.get(key);
        return param != null ? param.getValue() : null;
    }

    @CheckForNull
    String defaultParamValue(String key) {
        RuleParamDto param = this.ruleParams.get(key);
        return param != null ? param.getDefaultValue() : null;
    }

    @CheckForNull
    String currentSeverity() {
        return this.activeRule != null ? this.activeRule.getSeverityString() : null;
    }

    @CheckForNull
    String parentSeverity() {
        return this.parentActiveRule != null ? this.parentActiveRule.getSeverityString() : null;
    }

    @CheckForNull
    String defaultSeverity() {
        return this.rule.getSeverityString();
    }

    Map<String, ActiveRuleParamDto> activeRuleParamsAsMap() {
        return this.activeRuleParams;
    }

    Map<String, String> activeRuleParamsAsStringMap() {
        HashMap params = Maps.newHashMap();
        for (Map.Entry<String, ActiveRuleParamDto> param : this.activeRuleParams.entrySet()) {
            params.put(param.getKey(), param.getValue().getValue());
        }
        return params;
    }

    RuleActivatorContext setActiveRuleParams(@Nullable Collection<ActiveRuleParamDto> a) {
        this.activeRuleParams.clear();
        if (a != null) {
            for (ActiveRuleParamDto ar : a) {
                this.activeRuleParams.put(ar.getKey(), ar);
            }
        }
        return this;
    }

    RuleActivatorContext setParentActiveRuleParams(@Nullable Collection<ActiveRuleParamDto> a) {
        this.parentActiveRuleParams.clear();
        if (a != null) {
            for (ActiveRuleParamDto ar : a) {
                this.parentActiveRuleParams.put(ar.getKey(), ar);
            }
        }
        return this;
    }

    boolean isSameAsParent(ActiveRuleChange change) {
        if (this.parentActiveRule == null) {
            return false;
        }
        if (!StringUtils.equals((String)change.getSeverity(), (String)this.parentActiveRule.getSeverityString())) {
            return false;
        }
        for (Map.Entry<String, String> entry : change.getParameters().entrySet()) {
            if (entry.getValue() == null || entry.getValue().equals(this.parentParamValue(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    boolean isSame(ActiveRuleChange change) {
        ActiveRule.Inheritance inheritance = change.getInheritance();
        if (inheritance != null && !inheritance.name().equals(this.activeRule.getInheritance())) {
            return false;
        }
        String severity = change.getSeverity();
        if (severity != null && !severity.equals(this.activeRule.getSeverityString())) {
            return false;
        }
        for (Map.Entry<String, String> changeParam : change.getParameters().entrySet()) {
            ActiveRuleParamDto param = this.activeRuleParams.get(changeParam.getKey());
            if (changeParam.getValue() == null && param != null && param.getValue() != null) {
                return false;
            }
            if (changeParam.getValue() == null || param != null && StringUtils.equals((String)changeParam.getValue(), (String)param.getValue())) continue;
            return false;
        }
        return true;
    }

    void verifyForActivation() {
        WsUtils.checkRequest(RuleStatus.REMOVED != this.rule.getStatus(), "Rule was removed: %s", this.rule.getKey());
        WsUtils.checkRequest(!this.rule.isTemplate(), "Rule template can't be activated on a Quality profile: %s", this.rule.getKey());
        WsUtils.checkRequest(this.rulesProfile.getLanguage().equals(this.rule.getLanguage()), "Rule %s and profile %s have different languages", this.rule.getKey(), this.profile != null ? this.profile.getKee() : this.rulesProfile.getKee());
    }
}

