/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Function;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.ServerSide;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.qualityprofile.OrgActiveRuleDto;
import org.sonar.db.qualityprofile.QProfileDto;

@ServerSide
@ComputeEngineSide
public class QProfileComparison {
    private final DbClient dbClient;

    public QProfileComparison(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public QProfileComparisonResult compare(DbSession dbSession, QProfileDto left, QProfileDto right) {
        Map<RuleKey, OrgActiveRuleDto> leftActiveRulesByRuleKey = this.loadActiveRules(dbSession, left);
        Map<RuleKey, OrgActiveRuleDto> rightActiveRulesByRuleKey = this.loadActiveRules(dbSession, right);
        HashSet<RuleKey> allRules = new HashSet<RuleKey>();
        allRules.addAll(leftActiveRulesByRuleKey.keySet());
        allRules.addAll(rightActiveRulesByRuleKey.keySet());
        QProfileComparisonResult result = new QProfileComparisonResult(left, right);
        for (RuleKey ruleKey : allRules) {
            if (!leftActiveRulesByRuleKey.containsKey(ruleKey)) {
                result.inRight.put(ruleKey, rightActiveRulesByRuleKey.get(ruleKey));
                continue;
            }
            if (!rightActiveRulesByRuleKey.containsKey(ruleKey)) {
                result.inLeft.put(ruleKey, leftActiveRulesByRuleKey.get(ruleKey));
                continue;
            }
            this.compareActivationParams(dbSession, (ActiveRuleDto)leftActiveRulesByRuleKey.get(ruleKey), (ActiveRuleDto)rightActiveRulesByRuleKey.get(ruleKey), result);
        }
        return result;
    }

    private void compareActivationParams(DbSession session, ActiveRuleDto leftRule, ActiveRuleDto rightRule, QProfileComparisonResult result) {
        Map<String, String> rightParams;
        RuleKey key = leftRule.getRuleKey();
        Map<String, String> leftParams = QProfileComparison.paramDtoToMap(this.dbClient.activeRuleDao().selectParamsByActiveRuleId(session, leftRule.getId()));
        if (leftParams.equals(rightParams = QProfileComparison.paramDtoToMap(this.dbClient.activeRuleDao().selectParamsByActiveRuleId(session, rightRule.getId()))) && leftRule.getSeverityString().equals(rightRule.getSeverityString())) {
            result.same.put(key, leftRule);
        } else {
            ActiveRuleDiff diff = new ActiveRuleDiff();
            diff.leftSeverity = leftRule.getSeverityString();
            diff.rightSeverity = rightRule.getSeverityString();
            diff.paramDifference = Maps.difference(leftParams, rightParams);
            result.modified.put(key, diff);
        }
    }

    private Map<RuleKey, OrgActiveRuleDto> loadActiveRules(DbSession dbSession, QProfileDto profile) {
        return Maps.uniqueIndex((Iterable)this.dbClient.activeRuleDao().selectByProfile(dbSession, profile), (Function)ActiveRuleToRuleKey.INSTANCE);
    }

    private static Map<String, String> paramDtoToMap(List<ActiveRuleParamDto> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ActiveRuleParamDto dto : params) {
            map.put(dto.getKey(), dto.getValue());
        }
        return map;
    }

    private static enum ActiveRuleToRuleKey implements Function<ActiveRuleDto, RuleKey>
    {
        INSTANCE;


        public RuleKey apply(@Nonnull ActiveRuleDto input) {
            return input.getRuleKey();
        }
    }

    public static class ActiveRuleDiff {
        private String leftSeverity;
        private String rightSeverity;
        private MapDifference<String, String> paramDifference;

        public String leftSeverity() {
            return this.leftSeverity;
        }

        public String rightSeverity() {
            return this.rightSeverity;
        }

        public MapDifference<String, String> paramDifference() {
            return this.paramDifference;
        }
    }

    public static class QProfileComparisonResult {
        private final QProfileDto left;
        private final QProfileDto right;
        private final Map<RuleKey, ActiveRuleDto> inLeft = Maps.newHashMap();
        private final Map<RuleKey, ActiveRuleDto> inRight = Maps.newHashMap();
        private final Map<RuleKey, ActiveRuleDiff> modified = Maps.newHashMap();
        private final Map<RuleKey, ActiveRuleDto> same = Maps.newHashMap();

        public QProfileComparisonResult(QProfileDto left, QProfileDto right) {
            this.left = left;
            this.right = right;
        }

        public QProfileDto left() {
            return this.left;
        }

        public QProfileDto right() {
            return this.right;
        }

        public Map<RuleKey, ActiveRuleDto> inLeft() {
            return this.inLeft;
        }

        public Map<RuleKey, ActiveRuleDto> inRight() {
            return this.inRight;
        }

        public Map<RuleKey, ActiveRuleDiff> modified() {
            return this.modified;
        }

        public Map<RuleKey, ActiveRuleDto> same() {
            return this.same;
        }

        public Collection<RuleKey> collectRuleKeys() {
            HashSet<RuleKey> keys = new HashSet<RuleKey>();
            keys.addAll(this.inLeft.keySet());
            keys.addAll(this.inRight.keySet());
            keys.addAll(this.modified.keySet());
            keys.addAll(this.same.keySet());
            return keys;
        }
    }
}

