/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.sonar.api.notifications.Notification;

public class BuiltInQualityProfilesNotification {
    private static final String NUMBER_OF_PROFILES = "numberOfProfiles";
    private static final String PROFILE_NAME = ".profileName";
    private static final String LANGUAGE_KEY = ".languageKey";
    private static final String LANGUAGE_NAME = ".languageName";
    private static final String NEW_RULES = ".newRules";
    private static final String UPDATED_RULES = ".updatedRules";
    private static final String REMOVED_RULES = ".removedRules";
    private static final String START_DATE = ".startDate";
    private static final String END_DATE = ".endDate";
    private final List<Profile> profiles = new ArrayList<Profile>();

    public BuiltInQualityProfilesNotification addProfile(Profile profile) {
        this.profiles.add(profile);
        return this;
    }

    public Notification serialize() {
        Notification notification = new Notification("built-in-quality-profiles");
        notification.setFieldValue(NUMBER_OF_PROFILES, String.valueOf(this.profiles.size()));
        AtomicInteger count = new AtomicInteger();
        this.profiles.forEach(profile -> {
            int index = count.getAndIncrement();
            notification.setFieldValue(index + PROFILE_NAME, profile.getProfileName());
            notification.setFieldValue(index + LANGUAGE_KEY, profile.getLanguageKey());
            notification.setFieldValue(index + LANGUAGE_NAME, profile.getLanguageName());
            notification.setFieldValue(index + NEW_RULES, String.valueOf(profile.getNewRules()));
            notification.setFieldValue(index + UPDATED_RULES, String.valueOf(profile.getUpdatedRules()));
            notification.setFieldValue(index + REMOVED_RULES, String.valueOf(profile.getRemovedRules()));
            notification.setFieldValue(index + START_DATE, String.valueOf(profile.getStartDate()));
            notification.setFieldValue(index + END_DATE, String.valueOf(profile.getEndDate()));
        });
        return notification;
    }

    public static BuiltInQualityProfilesNotification parse(Notification notification) {
        Preconditions.checkState((boolean)"built-in-quality-profiles".equals(notification.getType()), (String)"Expected notification of type %s but got %s", (Object[])new Object[]{"built-in-quality-profiles", notification.getType()});
        BuiltInQualityProfilesNotification notif = new BuiltInQualityProfilesNotification();
        String numberOfProfilesText = notification.getFieldValue(NUMBER_OF_PROFILES);
        Preconditions.checkState((numberOfProfilesText != null ? 1 : 0) != 0, (Object)"Could not read the built-in quality profile notification");
        Integer numberOfProfiles = Integer.valueOf(numberOfProfilesText);
        IntStream.rangeClosed(0, numberOfProfiles - 1).mapToObj(index -> Profile.newBuilder().setProfileName(BuiltInQualityProfilesNotification.getNonNullFieldValue(notification, index + PROFILE_NAME)).setLanguageKey(BuiltInQualityProfilesNotification.getNonNullFieldValue(notification, index + LANGUAGE_KEY)).setLanguageName(BuiltInQualityProfilesNotification.getNonNullFieldValue(notification, index + LANGUAGE_NAME)).setNewRules(Integer.parseInt(BuiltInQualityProfilesNotification.getNonNullFieldValue(notification, index + NEW_RULES))).setUpdatedRules(Integer.parseInt(BuiltInQualityProfilesNotification.getNonNullFieldValue(notification, index + UPDATED_RULES))).setRemovedRules(Integer.parseInt(BuiltInQualityProfilesNotification.getNonNullFieldValue(notification, index + REMOVED_RULES))).setStartDate(Long.parseLong(BuiltInQualityProfilesNotification.getNonNullFieldValue(notification, index + START_DATE))).setEndDate(Long.parseLong(BuiltInQualityProfilesNotification.getNonNullFieldValue(notification, index + END_DATE))).build()).forEach(notif::addProfile);
        return notif;
    }

    private static String getNonNullFieldValue(Notification notification, String key) {
        String value = notification.getFieldValue(key);
        return Objects.requireNonNull(value, String.format("Notification field '%s' is null", key));
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public static class Profile {
        private final String profileName;
        private final String languageKey;
        private final String languageName;
        private final int newRules;
        private final int updatedRules;
        private final int removedRules;
        private final long startDate;
        private final long endDate;

        public Profile(Builder builder) {
            this.profileName = builder.profileName;
            this.languageKey = builder.languageKey;
            this.languageName = builder.languageName;
            this.newRules = builder.newRules;
            this.updatedRules = builder.updatedRules;
            this.removedRules = builder.removedRules;
            this.startDate = builder.startDate;
            this.endDate = builder.endDate;
        }

        public String getProfileName() {
            return this.profileName;
        }

        public String getLanguageKey() {
            return this.languageKey;
        }

        public String getLanguageName() {
            return this.languageName;
        }

        public int getNewRules() {
            return this.newRules;
        }

        public int getUpdatedRules() {
            return this.updatedRules;
        }

        public int getRemovedRules() {
            return this.removedRules;
        }

        public long getStartDate() {
            return this.startDate;
        }

        public long getEndDate() {
            return this.endDate;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private String profileName;
            private String languageKey;
            private String languageName;
            private int newRules;
            private int updatedRules;
            private int removedRules;
            private long startDate;
            private long endDate;

            private Builder() {
            }

            public Builder setLanguageKey(String languageKey) {
                this.languageKey = Objects.requireNonNull(languageKey, "languageKEy should not be null");
                return this;
            }

            public Builder setLanguageName(String languageName) {
                this.languageName = Objects.requireNonNull(languageName, "languageName should not be null");
                return this;
            }

            public Builder setProfileName(String profileName) {
                this.profileName = Objects.requireNonNull(profileName, "profileName should not be null");
                return this;
            }

            public Builder setNewRules(int newRules) {
                Preconditions.checkState((newRules >= 0 ? 1 : 0) != 0, (Object)"newRules should not be negative");
                this.newRules = newRules;
                return this;
            }

            public Builder setUpdatedRules(int updatedRules) {
                Preconditions.checkState((updatedRules >= 0 ? 1 : 0) != 0, (Object)"updatedRules should not be negative");
                this.updatedRules = updatedRules;
                return this;
            }

            public Builder setRemovedRules(int removedRules) {
                Preconditions.checkState((removedRules >= 0 ? 1 : 0) != 0, (Object)"removedRules should not be negative");
                this.removedRules = removedRules;
                return this;
            }

            public Builder setStartDate(long startDate) {
                this.startDate = startDate;
                return this;
            }

            public Builder setEndDate(long endDate) {
                this.endDate = endDate;
                return this;
            }

            public Profile build() {
                return new Profile(this);
            }
        }
    }
}

