/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.api.profiles.ProfileDefinition;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.api.utils.ValidationMessages;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;

public class BuiltInQProfileDefinitionsBridge
implements BuiltInQualityProfilesDefinition {
    private static final Logger LOGGER = Loggers.get(BuiltInQProfileDefinitionsBridge.class);
    private final List<ProfileDefinition> definitions;

    public BuiltInQProfileDefinitionsBridge() {
        this(new ProfileDefinition[0]);
    }

    public BuiltInQProfileDefinitionsBridge(ProfileDefinition ... definitions) {
        this.definitions = ImmutableList.copyOf((Object[])definitions);
    }

    public void define(BuiltInQualityProfilesDefinition.Context context) {
        Profiler profiler = Profiler.create((Logger)Loggers.get(this.getClass()));
        for (ProfileDefinition definition : this.definitions) {
            profiler.start();
            ValidationMessages validation = ValidationMessages.create();
            RulesProfile profile = definition.createProfile(validation);
            validation.log(LOGGER);
            if (profile == null) {
                profiler.stopDebug(String.format("Loaded definition %s that return no profile", definition));
                continue;
            }
            if (!validation.hasErrors()) {
                BuiltInQProfileDefinitionsBridge.define(context, profile);
            }
            profiler.stopDebug(String.format("Loaded deprecated profile definition %s for language %s", profile.getName(), profile.getLanguage()));
        }
    }

    private static void define(BuiltInQualityProfilesDefinition.Context context, RulesProfile profile) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile newQp = context.createBuiltInQualityProfile(profile.getName(), profile.getLanguage()).setDefault(profile.getDefaultProfile().booleanValue());
        for (ActiveRule ar : profile.getActiveRules()) {
            BuiltInQualityProfilesDefinition.NewBuiltInActiveRule newActiveRule = newQp.activateRule(ar.getRepositoryKey(), ar.getRuleKey());
            RulePriority overriddenSeverity = ar.getOverriddenSeverity();
            if (overriddenSeverity != null) {
                newActiveRule.overrideSeverity(overriddenSeverity.name());
            }
            for (ActiveRuleParam param : ar.getActiveRuleParams()) {
                newActiveRule.overrideParam(param.getKey(), param.getValue());
            }
        }
        newQp.done();
    }
}

