/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.property.PropertyDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.client.qualitygate.SelectWsRequest;

public class SelectAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public SelectAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("select").setDescription("Associate a project to a quality gate.<br>The '%s' or '%s' must be provided.<br>Project id as a numeric value is deprecated since 6.1. Please use the id similar to '%s'.<br>Requires the 'Administer Quality Gates' permission.", new Object[]{"projectId", "projectKey", "AU-TpxcA-iU5OvuD2FLz"}).setPost(true).setSince("4.3").setHandler((RequestHandler)this);
        action.createParam("gateId").setDescription("Quality gate id").setRequired(true).setExampleValue((Object)"1");
        action.createParam("projectId").setDescription("Project id. Project id as an numeric value is deprecated since 6.1").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("projectKey").setDescription("Project key").setExampleValue((Object)"my_project").setSince("6.1");
    }

    public void handle(Request request, Response response) {
        this.doHandle(SelectAction.toSelectWsRequest(request));
        response.noContent();
    }

    private void doHandle(SelectWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.checkQualityGate(dbSession, request.getGateId());
            ComponentDto project = this.getProject(dbSession, request.getProjectId(), request.getProjectKey());
            this.dbClient.propertiesDao().saveProperty(dbSession, new PropertyDto().setKey("sonar.qualitygate").setResourceId(project.getId()).setValue(String.valueOf(request.getGateId())));
            dbSession.commit();
        }
    }

    private static SelectWsRequest toSelectWsRequest(Request request) {
        return new SelectWsRequest().setGateId(request.mandatoryParamAsLong("gateId")).setProjectId(request.param("projectId")).setProjectKey(request.param("projectKey"));
    }

    private ComponentDto getProject(DbSession dbSession, @Nullable String projectId, @Nullable String projectKey) {
        ComponentDto project = (ComponentDto)this.selectProjectById(dbSession, projectId).or(() -> this.componentFinder.getByUuidOrKey(dbSession, projectId, projectKey, ComponentFinder.ParamNames.PROJECT_ID_AND_KEY));
        if (!this.userSession.hasPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, project.getOrganizationUuid()) && !this.userSession.hasComponentPermission("admin", project)) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
        return project;
    }

    private Optional<ComponentDto> selectProjectById(DbSession dbSession, @Nullable String projectId) {
        if (projectId == null) {
            return Optional.absent();
        }
        try {
            long dbId = Long.parseLong(projectId);
            return this.dbClient.componentDao().selectById(dbSession, dbId);
        }
        catch (NumberFormatException e) {
            return Optional.absent();
        }
    }

    private void checkQualityGate(DbSession dbSession, long id) {
        WsUtils.checkFound(this.dbClient.qualityGateDao().selectById(dbSession, id), "There is no quality gate with id=" + id, new Object[0]);
    }
}

