/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.protobuf.Message;
import java.util.Optional;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.qualitygate.QualityGateFinder;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsQualityGates;

public class GetByProjectAction
implements QualityGatesWsAction {
    private static final String PARAM_PROJECT = "project";
    private final UserSession userSession;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final QualityGateFinder qualityGateFinder;

    public GetByProjectAction(UserSession userSession, DbClient dbClient, ComponentFinder componentFinder, QualityGateFinder qualityGateFinder) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.qualityGateFinder = qualityGateFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("get_by_project").setInternal(false).setSince("6.1").setDescription("Get the quality gate of a project.<br />Requires one of the following permissions:<ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li><li>'Browse' on the specified project</li></ul>").setResponseExample(this.getClass().getResource("get_by_project-example.json")).setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("6.6", "The parameter 'projectId' has been removed"), new Change("6.6", "The parameter 'projectKey' has been renamed to 'project'"), new Change("6.6", "This webservice is now part of the public API")});
        action.createParam(PARAM_PROJECT).setDescription("Project key").setExampleValue((Object)"my_project").setRequired(true);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.componentFinder.getByKey(dbSession, request.mandatoryParam(PARAM_PROJECT));
            if (!this.userSession.hasComponentPermission("user", project) && !this.userSession.hasComponentPermission("admin", project)) {
                throw AbstractUserSession.insufficientPrivilegesException();
            }
            Optional<QualityGateFinder.QualityGateData> data = this.qualityGateFinder.getQualityGate(dbSession, project.getId());
            WsUtils.writeProtobuf((Message)GetByProjectAction.buildResponse(data), request, response);
        }
    }

    private static WsQualityGates.GetByProjectWsResponse buildResponse(Optional<QualityGateFinder.QualityGateData> data) {
        if (!data.isPresent()) {
            return WsQualityGates.GetByProjectWsResponse.getDefaultInstance();
        }
        QualityGateDto qualityGate = data.get().getQualityGate();
        WsQualityGates.GetByProjectWsResponse.Builder response = WsQualityGates.GetByProjectWsResponse.newBuilder();
        response.getQualityGateBuilder().setId(String.valueOf(qualityGate.getId())).setName(qualityGate.getName()).setDefault(data.get().isDefault());
        return response.build();
    }
}

