/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.property.PropertiesDao;
import org.sonar.db.property.PropertyDto;
import org.sonar.db.qualitygate.QualityGateConditionDao;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.db.qualitygate.QualityGateDao;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class QualityGates {
    public static final String SONAR_QUALITYGATE_PROPERTY = "sonar.qualitygate";
    private final DbClient dbClient;
    private final QualityGateDao dao;
    private final QualityGateConditionDao conditionDao;
    private final MetricFinder metricFinder;
    private final PropertiesDao propertiesDao;
    private final UserSession userSession;
    private final DefaultOrganizationProvider organizationProvider;

    public QualityGates(DbClient dbClient, MetricFinder metricFinder, UserSession userSession, DefaultOrganizationProvider organizationProvider) {
        this.dbClient = dbClient;
        this.dao = dbClient.qualityGateDao();
        this.conditionDao = dbClient.gateConditionDao();
        this.metricFinder = metricFinder;
        this.propertiesDao = dbClient.propertiesDao();
        this.userSession = userSession;
        this.organizationProvider = organizationProvider;
    }

    public QualityGateDto get(Long qGateId) {
        return this.getNonNullQgate(qGateId);
    }

    public QualityGateDto get(String qGateName) {
        return this.getNonNullQgate(qGateName);
    }

    public QualityGateDto rename(long idToRename, String name) {
        this.checkIsQualityGateAdministrator();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QualityGateDto toRename = this.getNonNullQgate(idToRename);
            this.validateQualityGate(dbSession, idToRename, name);
            toRename.setName(name);
            this.dao.update(toRename, dbSession);
            dbSession.commit();
            QualityGateDto qualityGateDto = toRename;
            return qualityGateDto;
        }
    }

    public QualityGateDto copy(long sourceId, String destinationName) {
        this.checkIsQualityGateAdministrator();
        this.getNonNullQgate(sourceId);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.validateQualityGate(dbSession, null, destinationName);
            QualityGateDto destinationGate = new QualityGateDto().setName(destinationName);
            this.dao.insert(dbSession, destinationGate);
            for (QualityGateConditionDto sourceCondition : this.conditionDao.selectForQualityGate(dbSession, sourceId)) {
                this.conditionDao.insert(new QualityGateConditionDto().setQualityGateId(destinationGate.getId().longValue()).setMetricId(sourceCondition.getMetricId()).setOperator(sourceCondition.getOperator()).setWarningThreshold(sourceCondition.getWarningThreshold()).setErrorThreshold(sourceCondition.getErrorThreshold()).setPeriod(sourceCondition.getPeriod()), dbSession);
            }
            dbSession.commit();
            QualityGateDto qualityGateDto = destinationGate;
            return qualityGateDto;
        }
    }

    public Collection<QualityGateDto> list() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Collection collection = this.dao.selectAll(dbSession);
            return collection;
        }
    }

    public void delete(long idToDelete) {
        this.checkIsQualityGateAdministrator();
        QualityGateDto qGate = this.getNonNullQgate(idToDelete);
        try (DbSession session = this.dbClient.openSession(false);){
            if (this.isDefault(qGate)) {
                this.propertiesDao.deleteGlobalProperty(SONAR_QUALITYGATE_PROPERTY, session);
            }
            this.propertiesDao.deleteProjectProperties(SONAR_QUALITYGATE_PROPERTY, Long.toString(idToDelete), session);
            this.dao.delete(qGate, session);
            session.commit();
        }
    }

    public void setDefault(DbSession dbSession, @Nullable Long idToUseAsDefault) {
        this.checkIsQualityGateAdministrator();
        if (idToUseAsDefault == null) {
            this.propertiesDao.deleteGlobalProperty(SONAR_QUALITYGATE_PROPERTY, dbSession);
        } else {
            QualityGateDto newDefault = this.getNonNullQgate(dbSession, idToUseAsDefault);
            this.propertiesDao.saveProperty(dbSession, new PropertyDto().setKey(SONAR_QUALITYGATE_PROPERTY).setValue(newDefault.getId().toString()));
        }
    }

    public void setDefault(@Nullable Long idToUseAsDefault) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.setDefault(dbSession, idToUseAsDefault);
            dbSession.commit();
        }
    }

    @CheckForNull
    public QualityGateDto getDefault() {
        Long defaultId = this.getDefaultId();
        if (defaultId == null) {
            return null;
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QualityGateDto qualityGateDto = this.dao.selectById(dbSession, defaultId.longValue());
            return qualityGateDto;
        }
    }

    public Collection<QualityGateConditionDto> listConditions(long qGateId) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Collection conditionsForGate = this.conditionDao.selectForQualityGate(dbSession, qGateId);
            for (QualityGateConditionDto condition : conditionsForGate) {
                Metric metric = this.metricFinder.findById((int)condition.getMetricId());
                if (metric == null) {
                    throw new IllegalStateException("Could not find metric with id " + condition.getMetricId());
                }
                condition.setMetricKey(metric.getKey());
            }
            Collection collection = conditionsForGate;
            return collection;
        }
    }

    public void dissociateProject(DbSession dbSession, ComponentDto project) {
        this.checkProjectAdmin(project);
        this.propertiesDao.deleteProjectProperty(SONAR_QUALITYGATE_PROPERTY, project.getId(), dbSession);
        dbSession.commit();
    }

    private boolean isDefault(QualityGateDto qGate) {
        return qGate.getId().equals(this.getDefaultId());
    }

    private Long getDefaultId() {
        PropertyDto defaultQgate = this.propertiesDao.selectGlobalProperty(SONAR_QUALITYGATE_PROPERTY);
        if (defaultQgate == null || StringUtils.isBlank((String)defaultQgate.getValue())) {
            return null;
        }
        return Long.valueOf(defaultQgate.getValue());
    }

    private QualityGateDto getNonNullQgate(long id) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QualityGateDto qualityGateDto = this.getNonNullQgate(dbSession, id);
            return qualityGateDto;
        }
    }

    private QualityGateDto getNonNullQgate(DbSession dbSession, long id) {
        QualityGateDto qGate = this.dao.selectById(dbSession, id);
        if (qGate == null) {
            throw new NotFoundException("There is no quality gate with id=" + id);
        }
        return qGate;
    }

    private QualityGateDto getNonNullQgate(String name) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QualityGateDto qGate = this.dao.selectByName(dbSession, name);
            if (qGate == null) {
                throw new NotFoundException("There is no quality gate with name=" + name);
            }
            QualityGateDto qualityGateDto = qGate;
            return qualityGateDto;
        }
    }

    private void validateQualityGate(DbSession dbSession, @Nullable Long updatingQgateId, @Nullable String name) {
        ArrayList<String> errors = new ArrayList<String>();
        if (Strings.isNullOrEmpty((String)name)) {
            errors.add(String.format("%s can't be empty", "Name"));
        } else {
            this.checkQgateNotAlreadyExists(dbSession, updatingQgateId, name, errors);
        }
        WsUtils.checkRequest(errors.isEmpty(), errors);
    }

    private void checkQgateNotAlreadyExists(DbSession dbSession, @Nullable Long updatingQgateId, String name, List<String> errors) {
        boolean isModifyingCurrentQgate;
        QualityGateDto existingQgate = this.dao.selectByName(dbSession, name);
        boolean bl = isModifyingCurrentQgate = updatingQgateId != null && existingQgate != null && existingQgate.getId().equals(updatingQgateId);
        if (!isModifyingCurrentQgate && existingQgate != null) {
            errors.add(String.format("%s has already been taken", "Name"));
        }
    }

    private void checkIsQualityGateAdministrator() {
        this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, this.organizationProvider.get().getUuid());
    }

    private void checkProjectAdmin(ComponentDto project) {
        if (!this.userSession.hasPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, project.getOrganizationUuid()) && !this.userSession.hasComponentPermission("admin", project)) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
    }
}

