/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.function.Function;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentLinkDto;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.project.ws.SearchMyProjectsData;
import org.sonar.server.project.ws.SearchMyProjectsDataLoader;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsProjects;
import org.sonarqube.ws.client.project.SearchMyProjectsRequest;

public class SearchMyProjectsAction
implements ProjectsWsAction {
    private static final int MAX_SIZE = 500;
    private final DbClient dbClient;
    private final SearchMyProjectsDataLoader dataLoader;
    private final UserSession userSession;

    public SearchMyProjectsAction(DbClient dbClient, SearchMyProjectsDataLoader dataLoader, UserSession userSession) {
        this.dbClient = dbClient;
        this.dataLoader = dataLoader;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search_my_projects").setDescription("Return list of projects for which the current user has 'Administer' permission. Maximum 1'000 projects are returned.").setResponseExample(this.getClass().getResource("search_my_projects-example.json")).addPagingParams(100, 500).setSince("6.0").setInternal(true).setHandler((RequestHandler)this);
        action.setChangelog(new Change[]{new Change("6.4", "The 'id' field is deprecated in the response")});
    }

    public void handle(Request request, Response response) throws Exception {
        WsProjects.SearchMyProjectsWsResponse searchMyProjectsWsResponse = this.doHandle(SearchMyProjectsAction.toRequest(request));
        WsUtils.writeProtobuf((Message)searchMyProjectsWsResponse, request, response);
    }

    private WsProjects.SearchMyProjectsWsResponse doHandle(SearchMyProjectsRequest request) {
        this.checkAuthenticated();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            SearchMyProjectsData data = this.dataLoader.load(dbSession, request);
            WsProjects.SearchMyProjectsWsResponse searchMyProjectsWsResponse = SearchMyProjectsAction.buildResponse(request, data);
            return searchMyProjectsWsResponse;
        }
    }

    private static WsProjects.SearchMyProjectsWsResponse buildResponse(SearchMyProjectsRequest request, SearchMyProjectsData data) {
        WsProjects.SearchMyProjectsWsResponse.Builder response = WsProjects.SearchMyProjectsWsResponse.newBuilder();
        ProjectDtoToWs projectDtoToWs = new ProjectDtoToWs(data);
        data.projects().stream().map(projectDtoToWs).forEach(arg_0 -> ((WsProjects.SearchMyProjectsWsResponse.Builder)response).addProjects(arg_0));
        response.getPagingBuilder().setPageIndex(request.getPage().intValue()).setPageSize(request.getPageSize().intValue()).setTotal(data.totalNbOfProjects()).build();
        return response.build();
    }

    private void checkAuthenticated() {
        this.userSession.checkLoggedIn();
    }

    private static SearchMyProjectsRequest toRequest(Request request) {
        return SearchMyProjectsRequest.builder().setPage(Integer.valueOf(request.mandatoryParamAsInt("p"))).setPageSize(Integer.valueOf(request.mandatoryParamAsInt("ps"))).build();
    }

    private static enum ProjectLinkDtoToWs implements Function<ComponentLinkDto, WsProjects.SearchMyProjectsWsResponse.Link>
    {
        INSTANCE;


        @Override
        public WsProjects.SearchMyProjectsWsResponse.Link apply(ComponentLinkDto dto) {
            WsProjects.SearchMyProjectsWsResponse.Link.Builder link = WsProjects.SearchMyProjectsWsResponse.Link.newBuilder();
            link.setHref(dto.getHref());
            if (!Strings.isNullOrEmpty((String)dto.getName())) {
                link.setName(dto.getName());
            }
            if (!Strings.isNullOrEmpty((String)dto.getType())) {
                link.setType(dto.getType());
            }
            return link.build();
        }
    }

    private static class ProjectDtoToWs
    implements Function<ComponentDto, WsProjects.SearchMyProjectsWsResponse.Project> {
        private final SearchMyProjectsData data;

        private ProjectDtoToWs(SearchMyProjectsData data) {
            this.data = data;
        }

        @Override
        public WsProjects.SearchMyProjectsWsResponse.Project apply(ComponentDto dto) {
            WsProjects.SearchMyProjectsWsResponse.Project.Builder project = WsProjects.SearchMyProjectsWsResponse.Project.newBuilder();
            project.setId(dto.uuid()).setKey(dto.getDbKey()).setName(dto.name());
            this.data.lastAnalysisDateFor(dto.uuid()).ifPresent(arg_0 -> ((WsProjects.SearchMyProjectsWsResponse.Project.Builder)project).setLastAnalysisDate(arg_0));
            this.data.qualityGateStatusFor(dto.uuid()).ifPresent(arg_0 -> ((WsProjects.SearchMyProjectsWsResponse.Project.Builder)project).setQualityGate(arg_0));
            Protobuf.setNullable((Object)Strings.emptyToNull((String)dto.description()), arg_0 -> ((WsProjects.SearchMyProjectsWsResponse.Project.Builder)project).setDescription(arg_0));
            this.data.projectLinksFor(dto.uuid()).stream().map(ProjectLinkDtoToWs.INSTANCE).forEach(arg_0 -> ((WsProjects.SearchMyProjectsWsResponse.Project.Builder)project).addLinks(arg_0));
            return project.build();
        }
    }
}

